#include"elf.h"
#include<sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include<unistd.h>
#include<assert.h>
#include<stdio.h>
#include<string.h>
#include<stdlib.h>

void print_e_type(Elf64_Half e_type)
{
        printf(" e_type: ");
        switch(e_type)
        {
                case ET_NONE:
                        printf("No file type");
                        break;
                case ET_REL:
                        printf("Relocatable file");
                        break;
                case ET_EXEC:
                        printf("Executable file");
                        break;
                case ET_DYN:
                        printf("Shared Object file");
                        break;
                case ET_CORE:
                        printf("Core file");
                        break;
                case ET_LOPROC:
                        printf("Processor Specific");
                        break;
                case ET_HIPROC:
                        printf("Processor Specific");
                        break;
                default:
                        printf("Bad Value");
                        break;
        }
        printf("\n ");
}

void print_e_machine(Elf64_Half e_machine)
{
        printf("\n e_machine: %u ", e_machine);
        switch(e_machine)
        {
                case EM_NONE:
                        printf(" No Machine \n");
                        break;
                case EM_M32:
                        printf(" AT & T WE 32100 \n");
                        break;
                case EM_SPARC:
                        printf(" SPARC \n");
                        break;
                case EM_386:
                        printf(" Intel 80386 \n");
                        break;
                case EM_68K:
                        printf(" Motorolla 68000 \n");
                        break;
                case EM_88K:
                        printf(" Motorolla 88000 \n");
                        break;
                case EM_860:
                        printf(" Intel 80860 \n");
                        break;
                case EM_MIPS:
                        printf(" MIPS RS3000 \n");
                        break;
                case EM_S370:
                        printf(" S70 \n");
                        break;
                case EM_ARM:
                        printf(" ARM machine \n");
                        break;
                case EM_IA_64:
                        printf(" IA 64 Machine\n");
                        break;
                default:
                        printf(" Bad Value \n");
                        break;
        }
}


void print_e_version(Elf64_Word  e_version)
{
        printf("\n e_version - object file version : ");
        switch(e_version)
        {
                case EV_NONE:
                        printf(" Invalid Version \n");
                        break;
                case EV_CURRENT:
                        printf(" Current Version \n");
                        break;
                default:
                        printf(" Bad Value \n");
                        break;
        }
}

void printProcessorSpecificFlags(Elf64_Word e_flags) //only available for ia64 
{
        switch(e_flags)
        {
        case EF_MIPS_NOREORDER:
                printf("A .norder directive found in one of the source files \n");
                break;
        case EF_MIPS_PIC:
                printf(" File contains position independent code \n");
                break;
        case EF_MIPS_CPIC:
                printf(" File contains code that follows the standard for accessing position independent code \n");
                break;
        case EF_MIPS_UCODE:
                printf(" File contains ucode (obsolete) \n");
                break;
        case EF_MIPS_ABI2:
                printf(" File contains MIPIII 32 bit ABI \n");
                break;
        case EF_MIPS_OPTION_FIRST:
                printf(" This .MIPS.options section in this file contains one or more descriptors ");
                break;
        case EF_MIPS_ARCH_ASE:
                printf("Application specific architectural extensions used by this object file \n");
                break;
        case EF_MIPS_ARCH_ASE_MDMX:
                printf("File uses MDMX multimedia extensions \n");
                break;
        case EF_MIPS_ARCH_ASE_M16:
                printf("File uses MIPS 16 ISA extensions \n");
                break;
        default:
                printf(" Bad Value\n");
                break;
        }
}


void printElfHeader(Elf64_Ehdr * e)
{
        print_e_ident(e);
        print_e_type(e->e_type);
        print_e_machine(e->e_machine);
        print_e_version(e->e_version);
        printf("\n Entry point address : %lx ", e->e_entry);
        printf("\n Offset of program header table : %lu " , e->e_phoff);
        printf("\n Offset of section header table : %lu " , e->e_shoff);
        printf("\n processor specific flags : %x ", e->e_flags);
        printProcessorSpecificFlags(e->e_flags); //only available for ia64 
        printf("\n Size of elf header : %u bytes" , e->e_ehsize);
        printf("\n Size of an entry in program header : %u bytes" , e->e_phentsize);
        printf("\n Number of entries in a program header : %u ", e->e_phnum);
        printf("\n Size of an entry in section header : %u bytes" , e->e_shentsize);
        printf("\n Number of entries in a section header : %u ", e->e_shnum);
        printf("\n Entry number of string table in the segment table : %u", e->e_shstrndx);
        printf("\n");
}


void print_e_ident(Elf64_Ehdr * e)
{
        printf("\n ");
        printf("\n EI_MAGIC: %x ", e->e_ident[0]);
        printf("\n EI_MAG1 : %c ", e->e_ident[1]);
        printf("\t EI_MAG2 : %c ", e->e_ident[2]);
        printf("\t EI_MAG3 : %c ", e->e_ident[3]);
        printf("\n EI_CLASS : %x ", e->e_ident[4]);
        switch(e->e_ident[4])
        {
                case 0:
                        printf("\t Invalid Class! ");
                        break;
                case 1:
                        printf("\t 32 bit object ");
                        break;
                case 2:
                        printf("\t 64 bit object ");
                        break;
                default:
                        printf("\t BAD Value !! ");
                        break;
        }
        printf("\n EI_DATA : %x ", e->e_ident[5]);
        switch(e->e_ident[5])
        {
                case 0:
                        printf("\t Invalid data encoding !");
                        break;
                case 1:
                        printf("\t 2's complement values with LSB encoding ");
                        break;
                case 2:
                        printf("\t 2's complement values with MSB encoding ");
                        break;
                default:
                        printf("\t BAD Value !! ");
                        break;
        }
        printf("\n File Version (EI_VERSION) : %x ", e->e_ident[6]);
        switch(e->e_ident[6])
        {
                case 0:
                        printf("\t Invalid version ");
                        break;
                case 1:
                        printf("\t Current Verson ");
                        break;
                default:
                        printf("\t BAD Value !! ");
                        break;
	}
        printf("\n EI_PAD: %x \n", e->e_ident[7]);
}

void printProgramHeader( Elf64_Phdr * phdr)
{
        printf("\n Program Header: ");
        printf("\n ---------------------------------------\n");
        printf("\n type of this segment: %lu ->", (unsigned long)phdr->p_type);
        switch(phdr->p_type)
        {
                case PT_NULL:
                        printf("Ignored entries \n");
                        break;
                case PT_LOAD:
                        printf("Loadable segment \n");
                        break;
                case PT_DYNAMIC:
                        printf("Dynamic linking information \n");
                        break;
                case PT_INTERP:
                        printf("Interpreter information \n");
                        break;
                case PT_NOTE:
                        printf("Note segment \n");
                        break;
                case PT_SHLIB:
                        printf("Reserved segment \n");
                        break;
                case PT_PHDR:
                        printf("Information about the program header table\n");
                        break;
                case PT_TLS:
                        printf("Thread-local storage segment\n");
                        break;
                case PT_NUM:
                        printf(" Number of defined types  ");
                        break;
                case PT_GNU_EH_FRAME:
                        printf("GCC .eh_frame_hdr segment \n");
                        break;
                case PT_GNU_STACK:
                        printf("Indicates stack executability\n");
                        break;
                case PT_SUNWBSS:
                        printf("Sun Specific segment\n");
                        break;
                case PT_HISUNW:
                        printf("Sun Specific segment \n");
                        break;
                case PT_SUNWSTACK:
                        printf(" Stack Segment \n");
                default:
                       if((phdr->p_type >= PT_LOOS) || (phdr->p_type >= PT_HIOS))
                        {
                                printf("\n Operating System specific header ");
                        }
                        else if((phdr->p_type >= PT_LOPROC) || (phdr->p_type >= PT_HIPROC))
                        {
                                printf("\n Processor System specific header ");
                        }
                        else
                        {
                                printf("Bad Value\n");
                        }
                        break;
        }
}


int printSectionHeader(Elf64_Shdr * shdr, char * stringTable , int length, char * sectionName)
{
        int retVal = 0; /* indicates if a section is afterburn */
        /* Currently assuming that the string table exists. But we need to fix this up  */
        if(length <= shdr->sh_name)
                printf("\n Wrong index ?? ");
        else
        if(shdr->sh_name != 0)
        {
                if(strcmp(stringTable + shdr->sh_name, sectionName) == 0)
                {
                        printf("\n Name index is : %x ", shdr->sh_name);
                        printf("Name of the section is: %s \n",  stringTable + shdr->sh_name);
                        printf("\n Address in memory of this section: %lu ", shdr->sh_addr);
                        printf("\n Offset of the first byte of this section in the file : %lu ", shdr->sh_offset);
                        printf("\n Sections size in bytes: %u ", shdr->sh_size);
                        printf("\n Address alignment constraints: %u ", shdr->sh_addralign);
                        printf("\n Section contains entries of fixed size : %s of %u ", shdr->sh_entsize == 0 ? "false" : "true", shdr->sh_entsize);
                        printf("\n");
                        retVal = 1;
                }
                else
                        if(shdr->sh_name != 0)
                                printf("\n Section Name: (%s)", stringTable + shdr->sh_name);
                        else
                                printf("\n First Section!");
        }
        printf("\n Returning! retVal is: %d", retVal);
        return retVal;
}


int readElfFile(char * fileName, char * sectionName, int flag, Elf64_Shdr * ptr_shdr)
{
        int fd = 0, retVal = 0, i=0, seekPos =0, stringTableLength =0;
        Elf64_Ehdr ehdr;
        char * stringTable;
        printf("\n Opening fileName : %s and sectionName: %s", fileName, sectionName);
        fd = open(fileName, flag, 0); //read your own "section"
        if(fd < 0)
        {
                printf("\n Could not open the elf file ! ");
                exit(0);
        }
        retVal = read(fd, &ehdr, sizeof(Elf64_Ehdr));
        if(retVal < 0)
        {
                perror("read failed because: ");
                close(fd);
                exit(0);
        }
        printf("\n Elf header size : %lu ", sizeof(Elf64_Ehdr));
        printElfHeader(&ehdr);
        if(ehdr.e_shstrndx != SHN_UNDEF)
        {

/*Read the string table first. */
                seekPos =  ehdr.e_shstrndx * ehdr.e_shentsize;
                seekPos = seekPos + ehdr.e_shoff;
                retVal = lseek(fd, seekPos, SEEK_SET);
                if(retVal < 0)
                {
                        perror("\n Could not lseek to the section header of the string table because: ");
                        printf("\n");
                        close(fd);
                        exit(0);
                }
		printf("\n lseek returned %d amd we were seeking at : %d \n", retVal, seekPos);
                seekPos = 0;
                retVal = read(fd, ptr_shdr, sizeof(Elf64_Shdr));
                if(retVal < 0)
                {
                        perror("\n Could not read the section header corresponding to the string section ");
                        printf("\n");
                        close(fd);
                        exit(0);
                }
                retVal = lseek(fd, ptr_shdr->sh_offset, SEEK_SET);
                if(retVal < 0)
                {
                        perror("\n Could not lseek to the string table because: ");
                        printf("\n");
                        close(fd);
                        close(fd);
                        exit(0);
                }
                stringTableLength = ptr_shdr->sh_size;
		stringTable = (char *)malloc(ptr_shdr->sh_size);
		if(stringTable == NULL)
		{
			perror("\n Could not allocate memory to stringTable because :");
			exit(0);
		}
                retVal = read(fd, stringTable, ptr_shdr->sh_size);
                if(retVal < 0)
                {
                        perror("Could not read the string table because : ");
                        printf("\n");
                        close(fd);
                        free(stringTable);
                        exit(0);
                }
        }
        else
        {
                printf("\n String table not defined for this elf file ");
                stringTable = NULL;
        }
        seekPos = ehdr.e_shoff;
        for(i=0; i<ehdr.e_shnum; i++)
        {
                retVal = lseek(fd, seekPos, SEEK_SET);
                if(retVal < 0)
                {
                        perror("lseek failed to seek to the section header because : ");
                        close(fd);
                        if(stringTable)
                                free(stringTable);
                        exit(0);
                }
                retVal = read(fd, ptr_shdr, sizeof(Elf64_Shdr));
                if(retVal < 0)
                {
                        printf("\n Failed to read a section header because : ");
                        close(fd);
                        if(stringTable)
                                free(stringTable);
                        exit(0);
                }
                if( printSectionHeader(ptr_shdr, stringTable, stringTableLength, sectionName) == 1)
                {
                        printf("\n FOUND~!");
                        break;
                }
                seekPos = seekPos + ehdr.e_shentsize;
        }
        printf("\n");
        assert(i!=ehdr.e_shnum);
	printf("\n String table is at address : %x \n", stringTable);
        if(stringTable)
                free(stringTable);
        return(fd);
}

