#include<sys/types.h>
#include<unistd.h>
#include<assert.h>
#include<stdio.h>
#include<stdlib.h>
#include"replaceAnnotated.h"


int lseekAndReadOrigFile(unsigned char ** origContents, int fd, unsigned long offset, unsigned int sizeOfInstns)
{
        int retVal = 0;
	printf("\n Inside lseekAndReadOrigFile : offset requested is : 0x%lx \n", offset);
        *origContents = (unsigned char *)NULL;
        *origContents= (unsigned char *)malloc(sizeOfInstns);
        if(*origContents == NULL)
        {
                perror("\n Could not allocated memory to origContents in replaceContents() because: ");
                printf("\n");
                retVal = -1;
		exit(0);
        }
        else
        {
                retVal = lseek(fd, offset, SEEK_SET); //read external file for replacing it.
                if(retVal < 0)
                {
                      printf("\n Could not lseek the contents of external file because: ");
                      printf("\n");
                      retVal = -1;
                }
                else
                {
        	        retVal = read(fd, *origContents, sizeOfInstns);
			printf("\n read returned: 0x%lx", retVal);
                        if(retVal < 0)
                        {
                	        printf("\n Could not read from the external file because: ");
				perror("\n Reason: ");
                                printf("\n");
				exit(0);
                        }
                }
        	printf("\n lseeked in external file at addres : 0x%lx ", offset);
        }
        return(retVal);
}

extern replacementAnnot_t repAnnotation[];

//we will read a size which is mentioned in the original size as the replacement code has maximum nops.
//The original code could have a lesser size, for instance in case of rsm and ssm. In the neutral code,
//the maximum possible length is annotated. So we should only read as much as is actually present in the 
//original code.

int lseekAndReadReplacementCode(unsigned char ** replaceWith, int internalFd, unsigned long length, unsigned int m_index)
{
        unsigned int sizeOfInstns = 0, retVal = 0;
	unsigned int offset  = 0;
        assert(repAnnotation[m_index].addr > 0);

//replace the contents at this address with contents at address annotXENmacro[m_index].addr
	offset = repAnnotation[m_index].addr & ~0<<2; //the last two bits could indicate the slot number which we should ignore
        printf("\n lseeking to offset : 0x%lx in internal file\n", offset);
        retVal = lseek(internalFd, offset, SEEK_SET);
        if(retVal < 0)
        {
                perror("\n Could not lseek to the correct address!");
                retVal = -1;
        }
        else
        {
                *replaceWith = (unsigned char *)NULL;
                sizeOfInstns = ((length - 1)/3) + 1;
                sizeOfInstns = sizeOfInstns * SIZE_OF_BUNDLE;
                retVal = sizeOfInstns;
                printf("\n size of instructions is: %d ", sizeOfInstns);
                *replaceWith = (unsigned char *)malloc(sizeOfInstns);
                if((*replaceWith) == NULL)
                {
                        perror("\n Could not allocated memory to replaceWith in replaceContents() because: ");
                        printf("\n");
                        retVal = -1;
                }
                else
                {
                        retVal = read(internalFd, *replaceWith, sizeOfInstns); //here sizeOfInstns would not work if its not an integral of 3
                        if(retVal < 0)
                        {
                                perror("\n Could not read the contents of replaceAnnot because: ");
                                printf(" Ret Val : 0x%lx \n", retVal);
                                printf("\n");
				perror("reason: ");
				exit(0);
                        }
                }
        }
        printf("\n leaving lseekAndReadInternalFile");
        return retVal;
}



int lseekAndReplaceOriginalFile(char * replaceWith, int fd, unsigned long offset, unsigned int  sizeOfInstns)
{
        int retVal = 0;
	printf("\n lseeking in external file to offset : 0x%lx \n", offset);
        retVal = lseek(fd, offset, SEEK_SET); //read external file for replacing it.
        if(retVal < 0)
        {
                perror("\n Could not lseek the contents of external file because: ");
                printf("\n");
                retVal = -1;
		printf("*************************BBYE !! ******************");
		printf("\n");
		exit(0);
        }
        else
        {
		printf("\n Now about to write !!! at fd : 0x%lx \n", retVal);
                retVal = write(fd, replaceWith, sizeOfInstns);
                if(retVal < 0)
                {
                        perror("\n Could not write to the external file because: ");
                        printf("\n");
                        retVal = -1;
			printf("*************************BBYE !! ******************");
			printf("\n");
			exit(0);
                }
		printf("\n Written %dbytes to external file ! \n", sizeOfInstns);
        }
        return retVal;

}

