#include "elf.h"
#ifndef FILEIO
#define FILEIO 1
extern long __executable_start;
extern long start_cover; //for verification rt now
extern long len_cover;
extern long start_bsw_0;
extern long len_bsw_0;
extern long start_bsw_1;
extern long len_bsw_1;
extern long start_rfi;
extern long len_rfi;
extern long start_ptc_e;
extern long len_ptc_e;
extern long start_read_psr;
extern long len_read_psr;


#define SIZE_OF_BUNDLE 16 //this is size in bytes
#define SIZE_OF_TEMPLATE 5 //bits 0 to 4 contain template information 
#define INSTN_BITS 41
#define BITS_IN_LONG 64
#define REM_BITS_OF_INSTN2_IN_LONG1 (BITS_IN_LONG - INSTN_BITS - SIZE_OF_TEMPLATE)
#define REM_BITS_OF_INSTN2_IN_LONG2 (INSTN_BITS - REM_BITS_OF_INSTN2_IN_LONG1)

#define SRC 0
#define DESTN 1
#define INCR 2

#define REPLACE 0
#define ADD 1


typedef struct args
{
        unsigned long type_of_arg;
	unsigned long total_bits; //makes sense for INCR type of argument. Code cleanup needed for this change!
        unsigned long start_bit;
        unsigned long num_bits;
}args_t;

typedef struct instn_args_annot
{
        unsigned long instn_num;
        args_t * args; //points to a size depending on the num of args for the instruction

}instn_args_annot_t;



typedef struct replacementAnnot
{
        char name[15];
        unsigned long addr;
        unsigned long len;
        unsigned long num_args;
        struct instn_args_annot * instnNumAndArgs;  //points to NULL if num_args=0
}replacementAnnot_t;

#endif


//function declarations

unsigned int findMatch(char * ptr);
int fillXENmacroAnnotation(int fd ,  Elf64_Shdr * shdr);
void copyTemplateInfo(uchar * origContents, uchar * replaceWith);
unsigned long replaceArgForInstn1(uint sbit, uint nbits, unsigned long arg, uchar * replaceWith);
int getOrigContigArgFromInstn1(char start_bit, char num_bits, uchar * origContents);
unsigned long replaceArgForInstn2(uint sbit, uint nbits, unsigned long arg, uchar * replaceWith);
int getOrigContigArgFromInstn2(char start_bit, char num_bits, uchar * origContents);
unsigned long replaceArgForInstn3(uint sbit, uint nbits, unsigned long arg, uchar * replaceWith);
int getOrigContigArgFromInstn3(char start_bit, char num_bits, uchar * origContents);
long getImmediateOperand(uchar * replaceWith);
int replaceImmediateOperand(uchar *replaceWith, unsigned long imm);
int replaceSparsedArguments(uint arg_num, uint m_index, unsigned long arg, unsigned char * replaceWith); 
int replaceContiguousArguments(uint r_instn_in_bundle, uint r_start_bit, uint r_num_bits, unsigned long arg, unsigned char *replaceWith);
int copyInstructionOperand(uchar * replaceWith, uint m_index, uint arg_num);
int alignTo8Bytes(int j);
int collectSparseArgument(char * ptr, unsigned int inst_num, char * origContents, uchar * temp, unsigned int start_bit, unsigned int num_bits, int op_size);
int getContiguousArgument(unsigned int inst_num, char * origContents, unsigned char * temp, unsigned int start_bit, unsigned int num_bits);
int getSensitiveInstnInfo(char * ptr, uchar num_args, char * origContents);
int handleEveryInstructionWithArgs(uchar * replaceWith, uint m_index);
unsigned long prepareSensitiveInstn(char **ptr, uint *m_index, uint * i_increment);
int replaceContents(Elf64_Shdr *shdr);
int readInternalImageAndMarkOffsets(char * fileName, char * sectionName, int flag);
int readExternalFileAndReplaceContents(char * fileName, char * sectionName, int flag, int internalFd);




