/* the lexical scanner for NUALGOL  */
%{

#include <stdio.h>
#include "algol.h"


int global_type = ID;     /* start out with this state */
int global_store = 0;     /* normally not anything */

%}
QUOTE		[\"]
DOT		[\.]
OCTAL		[0-7]*
HEX		[0-9A-F]
%%
"and"		{ return(AND); }
"array"		{ global_store = ARRAY; return(ARRAY); }
"begin"		{ return(BEGIN_SYM); }
"boolean"	{ global_type = BOOLEAN; return(BOOLEAN); }
"case"		{ return(CASE); }
"do"		{ return(DO); }
"else"		{ return(ELSE); }
"end"		{ return(END_SYM); }
"endcase"	{ return(ENDCASE); }
"endstr"	{ return(ENDSTRUCTURE); }
"endstruct"	{ return(ENDSTRUCTURE); }
"endstructure"	{ return(ENDSTRUCTURE); }
"external"	{ return(EXTERNAL); }
"false"		{ return(FALSE); }
"for"		{ return(FOR); }
"function"	{ global_type = FUNCTION; return(FUNCTION);}
"go"		{ return(GO); }
"goto"		{ return(GOTO); }
"if"		{ return(IF); }
"integer"	{ global_type = INTEGER; return(INTEGER);}
"long"          { global_type = LONG; return(LONG);}
"literal"	{ global_type = LITERAL; return(LITERAL);}
"not"		{ return(NOT); }
"or"		{ return(OR); }
"own"		{ global_store = OWN; return(OWN);}
"proc"		{ return(PROCEDURE); }
"procedure"	{ return(PROCEDURE); }
"pointer"	{ global_type = POINTER; return(POINTER);}
"real"		{ global_type = REAL; return(REAL);}
"return"	{ return(RETURN); }
"step"		{ return(STEP); }
"string"	{ global_type = STRING; return(STRING);}
"struct"	{ return(STRUCTURE); }
"structure"	{ return(STRUCTURE); }
"to"		{ return(TO); }
"then"		{ return(THEN); }
"true"		{ return(TRUE); }
"type"		{ return(TYPE); }
"union"		{ global_type = UNION; return(UNION);}
"until"		{ return(UNTIL); }
"while"		{ return(WHILE); }
[0-9]*          { return(NUMERIC_CONSTANT); }
[A-Za-z_$0-9]*  { return(ID); }
":="		{ return(ARROW); }
"+"		{ return(ADD_OP); }
"||"		{ return(CONCAT); }
":"		{ return(COLON); }
","		{ return(COMMA); }
"*"		{ return(MUL_OP); }
">"		{ return(REL_OP); }
";"		{ return(SEMICOLON);}
"**"		{ return(STARSTAR); }
"="		{ return(LOG_OP); }
"//"		{ return(MOD); }
"(*"		{ return(LEFT_MARK); }
"*)"		{ return(RIGHT_MARK); }
"("		{ return(LEFT_PAREN); }
")"		{ return(RIGHT_PAREN); }
"\["            { return(LEFT_SQUARE); }
"\]"		{ return(RIGHT_SQUARE); }
"@"		{ return(ATSIGN); }
{QUOTE}{QUOTE}	{ return(QUOTEQUOTE); }
{QUOTE}.{QUOTE}	{ return(STRING_CONSTANT); }
%%

static struct sym_table{ 
	char *var_name;	/* symbol name */   
	long address;		/* definition address */ 
	int type;		/* int,real,string, etc */ 
	int value; 		/* any known value or 0 */ 
	int indexes;		/* any array indexes or 0*/
	} sym_table;

int last_sym = 0;
char filename[256];  /* this is the size of a path  4096*/;

void *
yyerror( const char *msg)
{
        printf(msg);
};

int
yywrap()
{
 yyin = fopen(filename,"r+");
return 1;
};


char *yytext;

#include <stdio.h>
#include <stdlib.h>

struct Tree_block
{
char * identifier;
long type;
long operand;
long index1;
long index2;
long value;
struct Tree_block *left_child, *right_child;
};
void * push( struct Tree_block *address, struct Tree_block *next );
int i;
double number; 
char optr;
struct Tree_block *tp, *next, *head, *current, *end; 

int
init(char *name)
{
/* we add a name and create the list */
end=(struct Tree_block  *)calloc(1,sizeof(struct Tree_block));
current=(struct Tree_block  *)calloc(1,sizeof(struct Tree_block));
((struct Tree_block  *)current)->identifier=(char *)calloc(1,sizeof(name));
(struct Tree_block *)current->identifier = name;
head = current;  /* remember the top of list */
end = (struct Tree_block *)(char *)(-1);
(struct Tree_block *)current->right_child=end;
next = current;
++last_sym ;
}; /* end of init */
int test;

int
symbol(char *name)
{
if (last_sym == 0) { init(name); return(ID); }
else {
      current = head;

while (current != end)
{
if (strcmp(name,((struct Tree_block *)current)->identifier) == 0) 
{ /* we have a match return ID */
 ++last_sym;
  return(ID);
};
(struct Tree_block *)current->identifier=name; 
{
next=(struct Tree_block *)calloc(1,sizeof(struct Tree_block));
next->identifier=(char *)calloc(1,sizeof(name));
(struct Tree_block*)next->identifier=name;
++last_sym;
next->right_child=end;
push(current, next);
};
if(current == end) 
{
next=(struct Tree_block *)calloc(1,sizeof(struct Tree_block));
next->identifier=(char *)calloc(1,sizeof(name));
(struct Tree_block*)next->identifier=name;
++last_sym;
next->right_child=end;
return(ID);
}
 current = current->right_child;
}; /* end of top block */
}; /* end of while */
}; /* end of main  */
 
void *
push(struct Tree_block *address, struct Tree_block *next) 
{
struct Tree_block *new_node;
new_node=(struct Tree_block *)calloc(1,sizeof(struct Tree_block));
new_node->right_child=address->right_child;

next->left_child=address;
address->right_child=next;
next->right_child=new_node->right_child;
address->left_child=next;
  free(new_node);  /* free the temp */
}

int count = 0;

int        main( int argc, char **argv )
{
        char gp;

        if ( argc < 2 )
        {
        fprintf(stdout, " ltest  filename \n");
        exit(0);  /* MWC exit is zero == OK */
        }
           strcpy( filename, argv[1]);
        gp =   yywrap();
       printf(" filename = %s \n");

        while (gp =  yyparse() ){
          count++;
            if(gp == '1')exit(0);
         printf("%d  %d \"%s\"\n",count, gp, yytext);
           }
        printf(" done\n");
}

/* joe widows  */
