%{
 /* the working syntactical definition of JALGOL .ALG  booted in MWC */
int var_type;  /* carries the ID type between productions */
%}
%term LEFT_PAREN BEGIN_SYM PROCEDURE INDEX LENGTH ENDSTRUCTURE
%term AND ARRAY BOOLEAN CASE DO ELSE END_SYM ENDCASE
%term EXTERNAL FALSE FOR FUNCTION GO GOTO IF INTEGER
%term LITERAL NOT OR OWN POINTER REAL RETURN STEP STRING
%term STRUCTURE SUBSTRING 
%term TO THEN TRUE TYPE UNION UNTIL WHILE 
%term EQUAL LPAREN RPAREN
%term ARROW COLON COMMA CONCAT 
%term SEMICOLON LEFT_MARK RIGHT_MARK
%term RIGHT_PAREN ATSIGN QUOTEQUOTE
%term STARSTAR ADD_OP MUL_OP REL_OP LOG_OP

%term ID NAMED_VAR NAMED_BOOL NAMED_PTR  NAMED_LABEL NAMED_STRING
%term FUNCTION_ID BOOLEAN_ID PROC_ID STRING_ID
%term NAMED_STRUCT USER_TYPE STRING_CONSTANT NUMERIC_CONSTANT
%term COMMENT
%left NOT AND OR LOG_OP REL_OP ADD_OP MUL_OP
%right STARSTAR CONCAT
%%
algol : program
       ;
program: BLOCK
      | proc_list
       ;
BLOCK : BEGIN_HEAD  END_PART
      ;
BEGIN_HEAD :  BEGIN_SYM declare_list SEMICOLON {  printf(" BEGIN declare_list  \n"); }
           |  BEGIN_SYM { printf(" BEGIN \n"); }
       ;
END_PART:  stmt_list semi_list  END_SYM { printf(" stmt_list END \n"); }
       |  END_SYM  { printf(" END \n"); }
       ;
semi_list : SEMICOLON { printf(" semicolon \n"); }
          | semi_list SEMICOLON  { printf(" semi_list semicolon \n"); }
         ;
proc_list : proc_head BLOCK
         | proc_list SEMICOLON proc_head BLOCK
        ;
proc_head :  PROCEDURE  ID LPAREN id_list RPAREN
         ;
declare_list:  storage_type dcl_stmt
       | declare_list SEMICOLON 
       ;
dcl_stmt :  data_type id_list 
         ;
stmt_list :  stmt
          | stmt_list SEMICOLON stmt
          ;
data_type :
           BOOLEAN
                { printf(" data_type : BOOLEAN\n"); var_type = BOOLEAN; }
         | INTEGER
               { printf(" data_type : INTEGER\n");  var_type = INTEGER; }
         | POINTER
                { printf(" data_type : POINTER\n"); var_type = POINTER; }
         | REAL
               { printf(" data_type : REAL\n"); var_type = REAL; }
         | STRING
               { printf(" data_type : STRING\n"); var_type = STRING; }
         | structure_type
               { printf(" data_type : STRUCTURE\n"); var_type = STRUCTURE; }
         | USER_TYPE
               { printf(" data_type : USER_TYPE\n"); var_type = USER_TYPE; }
         | INTEGER ARRAY
               { printf(" data_type : INTEGER\n");  var_type = INTEGER; }
         | POINTER  ARRAY 
                { printf(" data_type : POINTER\n"); var_type = POINTER; }
         | REAL ARRAY
               { printf(" data_type : REAL\n"); var_type = REAL; }
         | STRING ARRAY
               { printf(" data_type : STRING\n"); var_type = STRING; }
         | structure_type
               { printf(" data_type : STRUCTURE\n"); var_type = STRUCTURE; }
         | USER_TYPE ARRAY
               { printf(" data_type : USER_TYPE\n"); var_type = USER_TYPE; }
         ;
storage_type :  
          OWN
        { printf(" OWN means initialize to 0, NULL, EMPTY, etc\n"); }
         | EXTERNAL
        { printf(" EXTERN means somebody else owns this address\n"); }
         ;
id_list :
        id_list COMMA ID
           { printf(" id_list, add ID to symbol table var_type\n"); }
          |  ID
               { printf(" add ID to symbol table using var_type\n"); }
        ;
structure_type :
          structure_define ENDSTRUCTURE
          { printf(" turn off the STRUCTURE qualifier condition \n"); }
          ;
structure_define :
         STRUCTURE ID LEFT_MARK
      { printf(" turn on the STRUCTURE qualifier condition : ID\n"); }
                declare_list
        { printf(" STRUCTURE declare_list \n"); }
        ; 
stmt :
        stmt semi_list label_stmt
        { printf(" stmts: list ; label_stmt\n"); }
      |  COMMENT label_stmt
        { printf(" stmt: COMMENT label_stmt\n"); }
      | label_stmt
        { printf(" stmts: label_stmt\n"); }
        ;
user_declare :
          TYPE data_type ID
 { printf(" using the globally defined data_type set ID as user_type \n"); } 
        ;
label_stmt :
     label_list stmts { printf(" lable_stmt : lable_list stmt\n"); }
     | stmts { printf(" label_stmt : stmt\n"); }
     ;
label_list :
     label_list label_mark
        { printf(" label_list : list label_mark\n"); }
     | label_mark
        { printf(" label_list : label_mark\n"); }
     ;
label_mark :
     ID COLON
 { printf(" create a new label here s_lookup(yytext,NAMED_LABEL,INSERT); \n"); }
     ;
stmts :
        any_stmt
        { printf(" stmt : any_stmt\n"); }
        | if_stmt
        { printf(" stmt : if_stmt\n"); }
        | for_stmt
        { printf(" stmt : for_stmt\n"); }
        ;

any_stmt :
        goto_stmt
        { printf(" any_stmt : goto_stmt\n"); }
        | while_stmt
        { printf(" any_stmt : while_stmt\n"); }
        | until_stmt
        { printf(" any_stmt : until_stmt\n"); }
        | assign_stmt
        { printf(" any_stmt : assign_stmt\n"); }
        | string_stmt
        { printf(" any_stmt : string_stmt\n"); }
        | proc_call
        { printf(" any_stmt : proc_call\n"); }
        | case_stmt
        { printf(" any_stmt : case_stmt\n"); }
        | BLOCK
        { printf(" any_stmt : block\n"); }
        | return_stmt
        { printf(" any_stmt : return_stmt\n"); }
        ;
if_stmt :
      IF bool_part then_part 
        { printf(" end if IF then else statement generate label \n"); }
     ;
bool_part :
        LPAREN boolean_expr RPAREN
        { printf(" add tmp_x = not tmp_x, jmp to label+2 \n"); }
        ;
then_part :
         THEN stmt
     { printf(" THEN stmt :: jmp to end of else\n"); }
        | THEN stmt ELSE stmt
     { printf(" THEN :: null block jmp to end of else\n"); }
        ;
for_stmt:
        FOR step_part step_part_2 DO stmt
    { printf(" generate for_branch_back :: jmp last_label: end_label \n"); }
        ;
step_part : NAMED_VAR  ARROW  expression STEP
        { printf(" step_part : NAMED_VAR = expression STEP\n"); }
        ;
step_part_2 :
         expression UNTIL expression
{ printf(" STEP eval(1) = eval(1) - eval(2) : gen_label, incr_code \n"); }
        ;
goto_stmt :
        GOTO NAMED_LABEL
          { printf(" GOTO ID  : jmp to address(ID) \n"); }
        | GO TO NAMED_LABEL
          { printf(" GOTO ID  : jmp to address(ID) \n"); }
        ;
while_stmt :
        WHILE bool_part RIGHT_PAREN DO stmt
  {  printf(" WHILE generate branch back to previous label,gen label+1\n"); }
        ;

until_stmt :
        UNTIL bool_part RIGHT_PAREN DO stmt
        { printf(" until_stmt:  generate label+3 \n"); }
        ;
assign_stmt :
        NAMED_VAR ARROW expression
         { printf(" assign_stmt : named_var := expression\n"); }
        | NAMED_BOOL ARROW boolean_expr
         { printf(" assign_stmt : named_bool := boolean_expr\n"); }
        | NAMED_BOOL ARROW expression
         { printf(" assign_stmt :  named_ptr :=  expression\n"); }
        ;
string_stmt :
        NAMED_STRING ARROW string_val
       { printf(" string_stmt : named_string := string_val\n"); }
        | substring_proc ARROW string_val
       { printf(" string_stmt: substring_proc := string_val\n"); }
        ;
string_val :
        expression CONCAT NAMED_STRING
          { printf(" string_val : expression || named_string\n"); }
        | string_val CONCAT expression
          { printf(" string_val : string_val || expression\n"); }
        | string_val CONCAT NAMED_STRING
          { printf(" string_val : string_val || named_string\n"); }
        | string_val CONCAT string_function
          { printf(" string_val : string_vall || string_function\n"); }
        | QUOTEQUOTE
          { printf(" string_val : '\0' (quotequote)\n"); }
        | STRING_CONSTANT
          { printf(" string_val : string_constant (quoted string)\n"); }
        | NAMED_STRING
          { printf(" string_val : NAMED_STRING\n"); }
        | string_function
          { printf(" string_val : string_function\n"); }
        | substring_proc
          { printf(" string_val : substring_proc\n"); }
        ;
substring_proc:
        SUBSTRING LEFT_PAREN NAMED_STRING COMMA expression
                   COMMA expression RIGHT_PAREN
  { printf(" substring_proc : substr( Id, expression, expression )\n"); }
        ;
string_function :
        INDEX LEFT_PAREN string_val COMMA string_val RIGHT_PAREN
     { printf(" string_function : returns integer (INDEX)\n"); }
        | LENGTH LEFT_PAREN string_val RIGHT_PAREN
     { printf(" string_function : returns integer (LENGTH)\n"); }
        ;

proc_call :
        PROC_ID LEFT_PAREN arg_list RIGHT_PAREN
        { printf(" proc_call : proc_id stack/arg eval/ jmp to\n"); }
        ;
arg_list :
        arg_list COMMA expression
        { printf(" arg_list : list, call by refernce evaluation\n"); }
        | expression
        { printf(" arg_list : call by reference evaluation\n"); }
        ;
return_stmt :
        RETURN
    { printf(" return_stmt : naked return [ check proc_type ]\n"); } 
        | RETURN any_value
{ printf(" return_stmt : return the reference [ che proc_type ]\n"); }
        ;
EXPR : any_value
     ;
any_value :
        boolean_expr
       { printf(" any_value : boolean_result\n"); }
        | NAMED_STRUCT
       { printf(" any_value : named_struct\n"); }
        | expression
       { printf(" any_value : numeric_result\n"); }
        | string_val
       { printf(" any_value : string_result\n"); }
        | NAMED_PTR
       { printf(" any_value : named_pointer ( holding result)\n"); } 
        ;
case_stmt :
        str_case
        { printf(" str_case \n");}
        | arithmetic_case
        { printf(" arithmetic_case \n");}
        ;
str_case :
        CASE string_val COLON string_cases ENDCASE
        { printf(" CASE strval : string_cases END \n");}
        ;
string_cases :
        string_cases  string_case
        { printf(" string_cases string_case \n");}     
        | string_case
        { printf(" string_case \n");}
        ;
string_case :
        string_val COLON any_stmt SEMICOLON
        { printf(" string_case: strval : any_stmt ;\n");}
        ;
arithmetic_case :
        CASE variable COLON arith_cases ENDCASE
        { printf(" CASE variable : arith_cases END\n");}
        ;
arith_cases :
        arith_cases arith_case
        { printf(" arith_cases arith_case \n");}
        | arith_case
        { printf(" arith_case \n");}
        ;
arith_case :
        expression COLON any_stmt SEMICOLON
        { printf(" arith_case: expression : any_stmt ;\n");}
        ;

expression :
        expression ADD_OP expression
      { printf(" expression : t3 = t1 +/- t2 \n"); }
        | expression MUL_OP expression
      { printf(" expression : t3 = t1 * or / t2 \n"); }
        | ADD_OP expression
      { printf(" expression : t1 = -1 t1 \n"); }
        | variable
       { printf(" expression : variable \n"); }
        | variable power_list
        { printf(" exprssion : variable power_list \n"); }
        ;
variable :
        LEFT_PAREN expression RIGHT_PAREN
     { printf(" variable : ( expression )\n"); }
        | NUMERIC_CONSTANT
     { printf(" variable : t1 = eval(NUMERIC_CONSTANT)\n"); }
        | function_call
     { printf(" variable : function call check return is numeric\n"); }
        | NAMED_VAR
     { printf(" variable : named_var t1 = [named_var]\n"); }
        | ATSIGN NAMED_PTR
     { printf(" variable : @ ptr : t1 = [ address(ptr) ]\n"); }
        ;
power_list :
        power_list STARSTAR variable
      { printf(" power_list : list ** variable \n"); }
        | STARSTAR variable
      { printf(" power_list : ** variable \n"); }
        ;
function_call :
        FUNCTION_ID LEFT_PAREN arg_list RIGHT_PAREN
       { printf(" function_call : arg_list/ check return type\n"); }
        | FUNCTION_ID LEFT_PAREN RIGHT_PAREN
       { printf(" function_call : no args/ check return type\n"); }
        ;

boolean_expr :
        boolean_expr OR boolean_expr
      { printf(" boolean_expr : t3 = t1 OR t2\n"); }
        | boolean_expr AND boolean_expr
      { printf(" expression : t3 = t1 AND t2 \n"); }
        | boolean_expr LOG_OP boolean_expr
      { printf(" expression : t3 = t1 = t2 \n"); }
        | boolean_expr REL_OP boolean_expr
      { printf(" expression : t3 = t1 < t2 \n"); }
        | notted_boolean
        ;
notted_boolean :
        NOT notted_boolean
      { printf(" notted boolean: t2 = NOT t1\n"); }
        | boolean_var
        ;
boolean_var :
        TRUE
     { printf(" boolean_var : TRUE \n"); }
        | FALSE
     { printf(" boolean_var : FALSE \n"); }
        | NAMED_BOOL
     { printf(" boolean_var : named_bool\n"); }
        | BOOLEAN_ID LEFT_PAREN arg_list RIGHT_PAREN
     { printf(" boolean_var : bool_funct(arg_list)\n"); }
        | BOOLEAN_ID LEFT_PAREN RIGHT_PAREN
     { printf(" boolean_var : bool_funct()\n"); }
        | LEFT_PAREN boolean_expr RIGHT_PAREN
     { printf(" boolean_var : ( boolean_expr ) \n"); }
        ;
%%
        /* end of the prototype algol grammar */


#include <stdio.h>
#define FNAMESIZE 255
extern char *yytext;
extern int yylex();
long lmalloc();

 extern FILE *yyin;
FILE *ftable;
FILE *faction;
FILE *ftemp;


/* joe widows  */
 

