#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <strings.h>
#include "ast.h"


typedef struct {
	char *name;
} ast_table_t;



ast_table_t ast_table[] = {
	{"NNULL"},
	{"NJoin"},
/* cpp */
	/* Lexical Conventions A.4 */
	
	{"NIdentifier"},
	/* Expressions A.4 */
	{"NUnqualified_id"},
	{"NQualified_id"},
	{"NQua_unqualified"},
	{"NQua_id"},
	{"NNested_name_specifier"},
	/* Declarations A.6 */
	{"NDeclaration"},
	{"NSimple_declaration"},
	{"NSimple_type_specifier"},
	/* Declarators A.7 */
	{"NDeclarator_func"},
	{"NDeclarator_id_typename"},
	{"NDeclarator_id"},
	{"NFunction_definition_ctor"},
	/* Classes A.8 */
	{"NClass_name"},
	/* others */
	{"NDos_dos_punts"},

	{"NAmbig"},
	{"NAmbig_join"}


};

AST ASTMake(node_t type, AST son0, AST son1, AST son2, AST son3, int line, char * text)
{ 
  AST s = (AST) malloc(sizeof(*s));
  bzero (s, sizeof (*s));
  s->type = type;
  s->line = line;
  s->text = text;
  s->no_nodes = 0;
  s->id = identificador_node_ast;
  identificador_node_ast++;
  if ( son0 ) {
         ASTSon0 (s) = son0;
         ASTParent (son0) = s;
	 s->no_nodes++;
  }
  if ( son1 ) {
         ASTSon1 (s) = son1;
         ASTParent (son1) = s;
	 s->no_nodes++;
  }
  if ( son2 ) {
         ASTSon2 (s) = son2;
         ASTParent (son2) = s;
	 s->no_nodes++;
  }
  if ( son3 ) {
         ASTSon3 (s) = son3;
         ASTParent (son3) = s;
	 s->no_nodes++;
  }
  return(s);
}

char *type2string (node_t type)
{
  return (ast_table[type].name);
}

void tab(FILE *f,int level)
{
	int i;
	for ( i = 0; i < level; i++ ) 
		if (i%3 !=0) fprintf(f," ");
		else fprintf(f,"|");
}


void ast_dump_rec (FILE *f,AST ast, int level , int node_num)
{
        if (!ast) return;
	tab(f,level);
	//fprintf(f,"type:%s(%d) line:%d text:%s nodes:%d node: %p parent: %p \n",ast_table[ast->type].name,ast->type,
			//ast->line,ast->text ? ast->text : "NULL",ast->no_nodes, ast, ast->parent);
	fprintf(f,"type:%s(%d) node:%d line:%d text:%s nodes:%d    {{{%d\n",ast_table[ast->type].name,ast->type,node_num,
			ast->line,ast->text ? ast->text : "NULL", ast->no_nodes,level+1);
	
	level++;
	if ( ASTSon0 (ast) ) ast_dump_rec(f,ASTSon0 (ast),level,0);
	if ( ASTSon1 (ast) ) ast_dump_rec(f,ASTSon1 (ast),level,1);
	if ( ASTSon2 (ast) ) ast_dump_rec(f,ASTSon2 (ast),level,2);
	if ( ASTSon3 (ast) ) ast_dump_rec(f,ASTSon3 (ast),level,3);
}

void ast_dump ( FILE *f, AST ast )
{
	ast_dump_rec(f,ast,0,0);
}

void ast2graphviz(AST ast)
{
	int node_id;
	int parent;
	printf("\ndigraph sortida{\n");
	if (ast != NULL){
		node_id = 2;
		parent = 1;
		printf("1[label=\"%s(%s)(id->%d)\"]\n",type2string(ASTType(ast)),ASTText(ast),ast->id);
		node_id=ast2graphviz_rec(ASTSon0(ast),parent,node_id,0);
		node_id=ast2graphviz_rec(ASTSon1(ast),parent,node_id,1);
		node_id=ast2graphviz_rec(ASTSon2(ast),parent,node_id,2);
		node_id=ast2graphviz_rec(ASTSon3(ast),parent,node_id,3);
	}
	printf("}\n");
}

int ast2graphviz_rec(AST ast, int parent, int node_id, int son)
{
	if (ast != NULL)
	{
		if (ASTText(ast)!=NULL)
			printf("%i[label=\"%s(%i-%s)[%i](id->%d)\"]\n",node_id, type2string(ASTType(ast)),ASTLine(ast),ASTText(ast),son,ast->id);
		else
			if (ASTLine(ast) != 0)
				printf("%i[label=\"%s(%i)[%i](id->%d)\"]\n",node_id, type2string(ASTType(ast)),ASTLine(ast),son,ast->id);
			else
				printf("%i[label=\"%s()[%i](id->%d)\"]\n",node_id, type2string(ASTType(ast)),son,ast->id);
		printf("%i->%i\n",parent,node_id);
		parent = node_id;
		node_id++;
		//printf("valor de node_id fill 1:%i\n",node_id);
		node_id=ast2graphviz_rec(ASTSon0(ast),parent,node_id,0);
		//printf("valor de node_id fill 2:%i\n",node_id);
		node_id=ast2graphviz_rec(ASTSon1(ast),parent,node_id,1);
		node_id=ast2graphviz_rec(ASTSon2(ast),parent,node_id,2);
		node_id=ast2graphviz_rec(ASTSon3(ast),parent,node_id,3);
	}
	return node_id;
}




