#include <stdlib.h>
//#include <strings.h>
#include "ast.h"

AST ast_join2 (AST tree1, AST tree2)
{
  if (!tree1) return tree2;
  if (!tree2) return tree1;
  return ASTMake2 (NJoin,tree1,tree2,0,0); 
}

AST ast_comma2 (AST tree1, AST tree2)
{
  if (!tree1) return tree2;
  if (!tree2) return tree1;
  return ASTMake2 (/*NComma JAIRO: NComma has been deleted from AST; use NJoin instead*/NJoin,tree1,tree2,0,0); 
}


AST ast_clone_rec (AST tree)
{

  AST cloned_ast;
  AST son0, son1 ,son2, son3;
  char *text;
  int line;
  int type;
  int id;

  if (!tree)  {
	return NULL;
  }

  type = tree -> type;
  son0 = ast_clone_rec (ASTSon0 (tree));
  son1 = ast_clone_rec (ASTSon1 (tree));
  son2 = ast_clone_rec (ASTSon2 (tree));
  son3 = ast_clone_rec (ASTSon3 (tree));
  line = tree -> line;
  id = tree -> id;
  text = tree -> text ? strdup (tree -> text) : NULL;
  cloned_ast = ASTMake (type, son0, son1, son2, son3, line, text);
  return (cloned_ast);
}


AST ast_clone (AST tree)
{
  return ast_clone_rec (tree);
}
