%{
#define YYDEBUG 1
#define YYERROR_VERBOSE

#include "ast.h"
#include "ast_utils.h"

typedef struct {
	char* text;
	int line;
} type_token_atrib;

static AST result;
int yyerror(char* s);
yydebug = 1;

%}


%union {
	type_token_atrib token_atrib;

	AST ast;
};


%token<token_atrib> IDENTIFIER 


%token<token_atrib> DOS_DOS_PUNTS 



%type<ast>identifier
%type<ast>id_expression qualified_id nested_name_specifier nested_name_specifier_opt 
%type<ast>declaration_seq declaration_seq_opt declaration simple_declaration decl_specifier decl_specifier_seq decl_specifier_seq_opt simple_type_specifier type_name 
%type<ast>direct_declarator declarator_id function_definition 
%type<ast>class_name 
%type<ast>dos_dos_punts dos_dos_punts_opt


%debug
 
%glr-parser

%start declaration_seq

%%

identifier
	: IDENTIFIER
		{ $$ = ASTLeaf(NIdentifier, $1.line, $1.text); }
	;

/* Expressions */


id_expression
	: identifier
		{ $$ = ASTMake1(NUnqualified_id, $1, 0,0); }
	| qualified_id
		{ $$ = ASTMake1(NQualified_id, $1, 0,0); }
	;

qualified_id
	: dos_dos_punts_opt nested_name_specifier identifier
		{ $$ = ASTMake4(NQua_unqualified, $1, $2, 0, $3, 0, 0); }
	| dos_dos_punts identifier
		{ $$ = ASTMake2(NQua_id, $1, $2, 0, 0); }
	;

nested_name_specifier
	: class_name dos_dos_punts nested_name_specifier_opt
		{ $$ = ASTMake3(NNested_name_specifier, $1, $2, $3, 0, 0); }
	;

nested_name_specifier_opt
	:
		{ $$ = 0; }
	| nested_name_specifier
		{ $$ = $1; }
	;

/* Declarations */

declaration_seq
	: declaration
		{ result = $$ = ASTMake1(NDeclaration, $1,0,0); }
	| declaration_seq declaration
		{ result = $$ = ast_join($1, ASTMake1(NDeclaration, $2,0,0)); }
	;

declaration_seq_opt
	: 
		{ $$ = 0; }
	| declaration_seq
		{ $$ = $1; }
	;

declaration
	: simple_declaration
		{ $$ = $1; }
	| function_definition
		{ $$ = $1; }
	;

simple_declaration
	: simple_type_specifier direct_declarator ';'

		{ $$ = ASTMake2(NSimple_declaration,$1,$2,0,0); }
	;

decl_specifier
	: simple_type_specifier
		{ $$ = $1; }
	;

decl_specifier_seq
	: decl_specifier_seq_opt decl_specifier 
		{ $$ = ast_join($1,$2); }%merge <merging>
	;

decl_specifier_seq_opt
	:
		{ $$ = 0; }
	| decl_specifier_seq
		{ $$ = $1; }
	;

simple_type_specifier
	: dos_dos_punts_opt nested_name_specifier_opt type_name
		{ $$ = ASTMake3(NSimple_type_specifier,$1,$2,$3,0,0); }
	;

type_name
	: class_name 
		{ $$ = $1; } 
	;


/* Declarators */


direct_declarator
	: declarator_id
		{ $$ = $1; }
	| direct_declarator '(' ')' 
		{ $$ = ASTMake4(NDeclarator_func, $1,0,0,0,0,0); }
	;

declarator_id
	: dos_dos_punts_opt nested_name_specifier_opt type_name
		{ $$ = ASTMake3(NDeclarator_id_typename, $1,$2, $3,0,0); } %merge <merging>
	| id_expression
		{ $$ = ASTMake1(NDeclarator_id, $1,0,0); } %merge <merging>
	;

function_definition
	: decl_specifier_seq_opt direct_declarator '{' '}'
		{ $$ = ASTMake4(NFunction_definition_ctor,$1,$2,0,0,0,0); } %merge <merging>
	;



/* Classes */

class_name
	: identifier
		{ $$ = ASTMake1(NClass_name, $1,0,0); }
	;

/* others */

dos_dos_punts
	: DOS_DOS_PUNTS
		{ $$ = ASTLeaf(NDos_dos_punts, $1.line,0); }
	;

dos_dos_punts_opt
	:
		{ $$ = 0; }
	| dos_dos_punts
		{ $$ = $1; }
	;

%%

#include "lex.yy.c"

int yyerror (char* s)
{
	fprintf(stderr, "%s in line %d\n", s, no_line);
	return 0;
}

AST merging2(YYSTYPE p, YYSTYPE s)
{
	AST res=0, primer, segon;
	primer = ast_clone(p.ast);
	segon = ast_clone(s.ast);
	if (ASTType(primer) != NAmbig && ASTType(segon)!=NAmbig) {
		AST join = ASTMake1(NAmbig_join,segon,0,"merging2");
		AST join2 = ASTMake2(NAmbig_join,primer,join,0,"merging2");
		res = ASTMake1(NAmbig,join2,0,"merging2");
	}
	else
	{
		AST ambig, nou;
		if (ASTType(primer) == NAmbig){
			ambig = primer;
			nou = segon;
		}
		else {
			ambig = segon;
			nou = primer;
		}
		res = ambig;
		ambig = ASTSon0(ambig);
		while (ASTSon1(ambig) != 0){
			ambig = ASTSon1(ambig);
		}
		AST join = ASTMake1(NAmbig_join,nou,0,"merging2");
		ASTSon1(ambig) = join;
		ASTParent(join) = ambig;
		
	}
	return res;
}

AST merging(YYSTYPE p, YYSTYPE s){
	return merging2(p,s);
}

int main( int argc, char *argv[] )
{
	extern FILE *yyin;
	yyin = fopen( argv[1], "r");
	identificador_node_ast=0;

	yyparse();
	if (result){
		printf("Ok, doned\n");
		ast2graphviz(result);
	}
	else
	{
		printf("error\n");
		return(1);
	}
	return(0);
}
