%code top {
#include <config.h>
/* We don't need perfect functions for these tests. */
#undef malloc
#undef memcmp
#undef realloc
}

%skeleton "lalr1.cc"
%debug
%error-verbose
%define api.value.type variant
%code requires
{
  #include <cassert>
  #include <cstdlib> // size_t and getenv.
  #include <iostream>
  #include <list>

  bool debug = false;

  /// A class that counts its number of instances.
  struct Object
  {
    char val;

    Object (char v)
      : val (v)
    {
      Object::instances.push_back(this);
      log (this, "Object::Object");
    }

    Object ()
      : val ('?')
    {
      Object::instances.push_back(this);
      log (this, "Object::Object");
    }

    Object& operator= (char v)
    {
      val = v;
      return *this;
    }

    ~Object ()
    {
      Object::instances.remove (this);
      log (this, "Object::~Object");
    }

    // Static part.
    typedef std::list<const Object*> objects;
    static objects instances;

    static bool
    empty ()
    {
      return instances.empty ();
    }

    static void
    log (Object const *o, const std::string& msg)
    {
      if (debug)
        {
          if (o)
            std::cerr << o << "->";
          std::cerr << msg << " {";
          const char* sep = " ";
          for (objects::const_iterator i = instances.begin(),
                                       i_end = instances.end();
               i != i_end;
               ++i)
            {
              std::cerr << sep << *i;
              sep = ", ";
            }
          std::cerr << " }" << std::endl;
        }
    }
  };
}

%code
{
  #include <cassert>
  #include <cstring> // strchr
  #include <stdexcept>
  int yylex (yy::parser::semantic_type *);
  Object::objects Object::instances;
  static char const *input;
}


%printer
{
  yyo << &$$ << " '" << $$.val << '\'';
  if ($$.val == 'p')
    throw std::runtime_error ("printer");
} <Object>;

%token <Object> 'a' 'E' 'e' 'p' 'R' 's' 'T'
%type  <Object> list item


%initial-action
{
  if (strchr (input, 'i'))
    throw std::runtime_error ("initial-action");
}

%%

start: list {};

list:
  item       { $$ = $1; }
  // Right recursion to load the stack.
| item list  { $$ = $1; }
;

item:
  'a'     { $$ = $1; }
| 'e'     { YYUSE ($$); YYUSE($1); error ("syntax error"); }
// Not just 'E', otherwise we reduce when 'E' is the lookahead, and
// then the stack is emptied, defeating the point of the test.
| 'E' 'a' { YYUSE($1); $$ = $2; }
| 'R'     { YYERROR; }
| 'p'     { $$ = $1; }
| 's'     { $$ = $1; throw std::runtime_error ("reduction"); }
| 'T'     { YYABORT; }
| error   { yyerrok; }
;
%%

int
yylex (yy::parser::semantic_type *lvalp)
{
  // 'a': no error.
  // 'e': user action calls error.
  // 'E': syntax error, with yyerror that throws.
  // 'i': initial action throws.
  // 'l': yylex throws.
  // 'R': call YYERROR in the action
  // 's': reduction throws.
  // 'T': call YYABORT in the action
  switch (int res = *input++)
  {
  case 'l':
    throw std::runtime_error ("yylex");
  default:
    lvalp->build (res);
    // Fall through.
  case 0:
    return res;
  }
}

/* A C++ error reporting function.  */
void
yy::parser::error (const std::string& m)
{
  throw std::runtime_error (m);
}

int
main (int argc, const char *argv[])
{
  switch (argc)
  {
    case 2:
      input = argv[1];
      break;
    case 3:
      assert (std::string(argv[1]) == "--debug");
      debug = 1;
      input = argv[2];
      break;
    default:
      abort ();
  }

  yy::parser parser;
  debug |= !!getenv ("YYDEBUG");
  parser.set_debug_level (debug);
  int res = 2;
  try
  {
    res = parser.parse ();
  }
  catch (const std::exception& e)
  {
    std::cerr << "exception caught: " << e.what () << std::endl;
  }
  catch (...)
  {
    std::cerr << "unknown exception caught" << std::endl;
  }
  Object::log (YY_NULL, "end");
  assert (Object::empty());
  return res;
}
