/* Copyright (C) 1994, 1999, 2002, 2004 Free Software Foundation, Inc.
This file is part of the GNU C Library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/*
 * My personal strstr() implementation that beats most other algorithms.
 * Until someone tells me otherwise, I assume that this is the
 * fastest implementation of strstr() in C.
 * I deliberately chose not to comment it.  You should have at least
 * as much fun trying to understand it, as I had to write it :-).
 *
 * Stephen R. van den Berg, berg@pool.informatik.rwth-aachen.de
 *
 *
 * Improved 2004-02-15	Jose C. C. Da Silva, <digital at joescat dot com>
 *			Now runs faster. Removed "possible ANSI violation".
 *			+Faster exit if strstr("big_needle","big_needle....").
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if defined _LIBC || defined HAVE_STRING_H
# include <string.h>
#endif

typedef unsigned chartype;

#undef strstr

char *
strstr (const char *phaystack, const char *pneedle)
{
  register const unsigned char *haystack, *needle, *rhaystack, *rneedle;
  register chartype a, b, c;

  haystack = (const unsigned char *) phaystack;

  b = (chartype) *pneedle;
  if (b != '\0')
    {
      do
	{
	  a = *haystack++;
	  if (a == '\0')
	    goto foundnothing;
	  if (a == b)
	    break;
	  a = *haystack++;
	  if (a == '\0')
	    goto foundnothing;
	}
      while (a != b);

      needle = (const unsigned char *) pneedle;
      needle++;
      c = *needle++;
      if (c == '\0')
	goto foundneedle;

      goto jump_in;

      for (;;)
	{
	  do
	    {
	      a = *haystack++;
	      if (a == '\0')
		goto foundnothing;
	      if (a == b)
		break;
	      a = *haystack;
	      if (a == '\0')
		goto foundnothing;
more_hay:     haystack++;
	    }
	  while (a != b);

jump_in:  a = *haystack;
	  if (a == '\0')
	    goto foundnothing;

	  if (a != c)
	    goto more_hay;

	  rneedle = needle;
	  rhaystack = haystack;

	  do
	    {
	      a = *rneedle++;
	      if (a == '\0')
		goto foundneedle;
	      if (*++rhaystack != a)
		break;
	      a = *rneedle++;
	      if (a == '\0')
		goto foundneedle;
	    }
	  while (*++rhaystack == a);

	  if (*rhaystack == '\0')
	    goto foundnothing;
	}
foundnothing:
      return 0;

foundneedle:
      --haystack;
    }
  return (char*) haystack;
}
