#include <locale.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "gnulib-memxfrm.h"
#include "coreutils-memxfrm.h"

void
compare (char *string, size_t size, int repeat)
{
  int i;
  struct rusage snap0, snap1, snap2;

  getrusage (RUSAGE_SELF, &snap0);

  for (i = 0; i < repeat; i++)
    {
      char stackbuf[4000];
      size_t length = sizeof (stackbuf);
      char * result = gnulib_memxfrm (string, size, stackbuf, &length);
      if (result != stackbuf)
        free (result);
    }

  getrusage (RUSAGE_SELF, &snap1);

  for (i = 0; i < repeat; i++)
    {
      char stackbuf[4000];
      /* code taken from coreutils/src/sort.c */
      size_t tlen = coreutils_memxfrm (stackbuf, sizeof stackbuf, string, size);
      bool fits = tlen <= sizeof stackbuf;
      char *result;

      if (fits && tlen <= sizeof stackbuf)
        result = stackbuf;
      else
        {
          result = malloc (tlen + 1);
          coreutils_memxfrm (result, tlen + 1, string, size);
        }
      if (result != stackbuf)
        free (result);
    }

  getrusage (RUSAGE_SELF, &snap2);

  printf ("Time for gnulib_memxfrm: %g\n",
          (snap1.ru_utime.tv_sec - snap0.ru_utime.tv_sec) * 1.0
          + (snap1.ru_utime.tv_usec - snap0.ru_utime.tv_usec) * 1e-6);
  printf ("Time for coreutils_memxfrm: %g\n",
          (snap2.ru_utime.tv_sec - snap1.ru_utime.tv_sec) * 1.0
          + (snap2.ru_utime.tv_usec - snap1.ru_utime.tv_usec) * 1e-6);
}

int main ()
{
  /* Use an average locale.  */
  setlocale (LC_ALL, "de_DE.UTF-8");

  /* A short string.  */
  {
    char string[] = "Nach Unternehmertätigkeit in der Ölindustrie wurde Bush zweimal zum Gouverneur von Texas gewählt (1994 und 1998).\0Bei den Präsidentschaftswahlen im Jahr 2000 gewann Bush gegen den Demokraten und amtierenden Vizepräsidenten Al Gore und wurde bei den Wahlen im Jahr 2004 im Amt bestätigt.";
    compare (string, sizeof (string) - 1, 1000);
    compare (string, sizeof (string) - 1, 1000);
    compare (string, sizeof (string) - 1, 1000);
  }

  /* A long string.  */
  {
    char string[] = "Leben\0"
      "Werdegang\0"
      "Geboren als Sohn von Barbara Pierce Bush und George H. W. Bush wuchs George W. zusammen mit vier jüngeren Geschwistern – Jeb, Neil, Marvin und Dorothy – in Midland und Houston auf. Eine weitere jüngere Schwester, Robin, verstarb 1953 dreijährig an Leukämie.\0"
      "Laura Bush\0"
      "Bush besuchte von 1961 bis 1964 die Phillips Academy, die auch sein Vater besucht hatte. Anschließend studierte er von September 1964 bis Mai 1968 Geschichte an der Yale University, wo er, ebenfalls wie sein Vater, Mitglied der Vereinigung Skull & Bones und des Studentenbundes Delta Kappa Epsilon war. Im Oktober 1965 wurde er dessen Präsident, wie zuvor ebenfalls sein Vater. 1968 schloss er sein Studium an der Yale-Universität als Bachelor in Geschichte ab. Zwischen 1972 und 1975 besuchte George W. Bush die Harvard Business School der Harvard University, wo er den Titel MBA (Master of Business Administration) erwarb. 1977 heiratete er Laura Welch. Die Zwillingstöchter Jenna und Barbara wurden am 25. November 1981 geboren.\0"
      "Wehrdienst in der Nationalgarde\0"
      "Bush verpflichtete sich 1968 für sechs Jahre bei der Nationalgarde.[1] Bei der Air National Guard in Texas wurde er Leutnant, Pilot und Führer einer Staffel F-102 Delta Daggers. Da die Nationalgarde zu dieser Zeit vorwiegend im Inland eingesetzt wurde, sah sich Bush später mit dem Vorwurf konfrontiert, einer Einberufung in die Army zuvorgekommen zu sein und sich damit einem Einsatz in Vietnam entzogen zu haben und wurde daher draft dodger gescholten („ein sich der Einberufung Entziehender“), bei patriotischen Amerikanern alles andere als ein Ehrentitel. Dies war jedoch damals nicht nur unter Politikersöhnen eine durchaus verbreitete Praxis (sein Vater war damals Kongressabgeordneter im Repräsentantenhaus). Der Verdacht, Bush habe außerdem seine sich aus dem Dienst in der Nationalgarde ergebenden Pflichten nicht gewissenhaft erfüllt, hatte deshalb größeres politisches Gewicht. Auf Druck der Öffentlichkeit ließ er daher im Februar 2004 die Akten über diese Zeit für Untersuchungen freigeben.\0"
      "Unternehmertätigkeit\0"
      "Seine Unternehmertätigkeit begann Bush im Jahr 1978 in der Erdölförderindustrie mit der Gründung von Arbusto Energy (span. für Busch), später in Bush Exploration umbenannt. Als Anfang der 1980er-Jahre die Ölpreise einbrachen, geriet das Unternehmen in Schwierigkeiten und musste im Jahr 1984 mit dem Ölunternehmen Spectrum 7 Energy Corp. fusionieren. Bush wurde Vorsitzender des Unternehmens. Als im Jahr 1986 die Ölpreise erneut einbrachen, wurde es jedoch zahlungsunfähig und von Harken Energy Corp. aufgekauft. Bush wurde dadurch einer der Direktoren bei Harken.\0"
      "Religiosität und Alkoholprobleme\0"
      "Die Probleme Bushs im Umgang mit Alkohol wurden im Jahr 1976 aktenkundig. Wegen Trunkenheit am Steuer wurde ihm in Maine befristet der Führerschein entzogen. Zudem musste Bush sich einem strengen Entzug unterwerfen. Zehn Jahre später konvertierte er von den Anglikanern zu den Methodisten um fortan als Wiedergeborener Christ völlig auf Alkohol zu verzichten. Dieser Wechsel seiner Konfession im Jahre 1986 stellt eine einschneidende Veränderung seines Privatlebens dar.\0"
      "Politische Karriere\0"
      "1988 war George W. Bush Mitglied des Wahlkampfteams seines Vaters bei dessen schließlich gewonnener Präsidentschaftswahl. Anschließend erwarb er, gemeinsam mit nahen Freunden seines Vaters, das Baseballteam Texas Rangers (sein Anteil betrug 5 %). Er war bis zu seiner Wahl zum Gouverneur von Texas 1994 der Managing Partner des Teams. Mit dem Verkauf seines Anteils an den Texas Rangers 1998 verdiente Bush 15 Millionen Dollar.\0"
      "George W. Bush besitzt die Prairie Chapel Ranch bei Crawford in Texas, auf der er seine Ferien verbringt und auch Staatsgäste empfing. Er hält sich außerdem oft im Sommersitz seines Vaters Walker’s Point bei Kennebunkport in Maine auf, wo auch Staatsgäste empfangen wurden.\0"
      "Gouverneur von Texas\0"
      "Die texanische Gouverneurswahl am 8. November 1994 konnte Bush gegen die demokratische Amtsinhaberin Ann Richards für sich entscheiden. Sein Wahlkampf wurde – wie alle nachfolgenden – von Karl Rove geplant. Um seine Position auch unter den demokratischen Wählern zu festigen, setzte Bush in seiner ersten Amtszeit auf weitgehende Kooperation mit dem politischen Gegner; so ernannte er einen Demokraten zu seinem Stellvertreter und stärkte diesem den Rücken, indem er sich beispielsweise für Gesetzesvorhaben der gegnerischen Fraktion im texanischen Parlament einsetzte.\0"
      "1998 wurde er als texanischer Gouverneur wiedergewählt, sein Gegenkandidat war Garry Mauro. Bush war der erste Gouverneur in der texanischen Geschichte, dem die Wiederwahl gelang.\0"
      "In seiner Amtszeit war Bush ein entschiedener Befürworter der Todesstrafe: 152 zum Tode Verurteilten verweigerte er während seiner Amtszeit die Begnadigung. Dieser Umstand führte bei den Gegnern der Todesstrafe im In- und Ausland wiederholt zu scharfer Kritik.\0"
      "Der Wahlkampf 2000\0"
      "Im Jahr 2000 wurde Bush zum Präsidentschaftskandidaten der Republikaner nominiert und trat unter dem Motto vom „mitfühlenden Konservatismus“ (compassionate conservatism) mit Richard Cheney gegen den Kandidaten der Demokraten und damaligen Vizepräsidenten Al Gore sowie gegen den von den Grünen nominierten (international als Verbraucherschutzanwalt bekannten) Ralph Nader an. Die Entscheidung wurde ein hartes Kopf-an-Kopf-Rennen zwischen den beiden Hauptkandidaten Bush und Gore, so dass die Entscheidung schließlich nur noch vom Ergebnis im Bundesstaat Florida abhing.\0"
      "Die Ergebnisse in Florida waren in ihrer Auszählung jedoch überaus umstritten, was die Vereinigten Staaten bis an den Rand einer Staatskrise führte. Erst ein Urteil des Supreme Court beendete schließlich die laufenden Neuauszählungen der Stimmen. Das Gericht erklärte die von Floridas Staatsgericht geforderte (und von Al Gore verlangte) Neuauszählung der Stimmen für verfassungswidrig, weil unordentlich und in den verschiedenen Distrikten des Bundesstaates uneinheitlich organisiert. Eine verfassungsgemäße Neuauszählung sei aber nicht mehr innerhalb der vorgesehenen Frist zu gewährleisten, deshalb sei jegliche Neuauszählung zu stoppen. Somit wurde die erste Stimmenzählung, bei der George W. Bush knapp führte, automatisch bestätigt. Diese Entscheidung fiel mit der denkbar knappsten Mehrheit von fünf zu vier Richterstimmen. Von der Minderheit stimmten zwei Richter dafür, die Neuauszählung wie begonnen weiterlaufen zu lassen; zwei teilten zwar die Mehrheitsmeinung dahingehend, dass die laufende Neuauszählung nicht korrekt ablaufe, wollten aber den Fall an das oberste Gericht von Florida zurückverweisen, das einheitliche Standards festlegen sollte, nach denen dann alle Stimmen erneut gezählt werden sollten, gegebenenfalls auch mit Verlängerung der Frist.\0"
      "Bush erhielt insgesamt etwa 500.000 Wählerstimmen weniger als Gore, konnte aber mehr Wahlmännerstimmen auf sich vereinigen, was bei der indirekten Präsidentenwahl in den Vereinigten Staaten ausschlaggebend ist.\0"
      "Präsidentschaft\0"
      "Erste Amtszeit als Präsident\0"
      "Gerhard Schröder zusammen mit Bush im Weißen Haus (2001)\0"
      "Am 20. Januar 2001 wurde Bush vereidigt. Er wurde damit der zweite Präsident in der Geschichte der Vereinigten Staaten, dessen Vater ebenfalls Präsident gewesen war – diese Konstellation traf zuvor nur auf den sechsten Präsidenten, John Quincy Adams, zu, dessen Vater John Adams der zweite Präsident gewesen war. George W. Bush ist auch der erste Präsident mit einem MBA-Titel.\0"
      "Mit Bush zogen viele Republikaner wieder ins Weiße Haus ein, die schon unter seinem Vater wichtige Ämter innegehabt hatten, insbesondere Richard Cheney als Vizepräsident und Donald Rumsfeld als Verteidigungsminister. Außenminister wurde der frühere Golfkriegsgeneral Colin Powell. Die wichtigsten Berater waren weiterhin Karl Rove und – als Sicherheitsberaterin – Condoleezza Rice. Viele der neuen Mitarbeiter der Bush-Regierung waren vorher Mitglieder der neokonservativen Denkfabrik Project for the New American Century, etwa Richard Perle, Richard Armitage, Paul Wolfowitz oder Lewis Libby.\0"
      "Wie in seiner Zeit als texanischer Gouverneur kündigte George W. Bush auch zu Beginn seiner ersten Amtszeit ein möglichst einvernehmliches, zumindest abgestimmtes Handeln mit dem politischen Gegner an. Als Schwerpunkte benannte er eine Verbesserung des Bildungswesens, Steuersenkungen, Rechenschaftspflichten politischer Akteure gegenüber dem Volk, Stärkung des Militärs und Schaffung von Möglichkeiten für Arbeiter, Teile der Sozialversicherungsbeiträge privat zu investieren. Wichtiger Partner bei der Arbeit mit dem Senat wurde für Bush der Demokrat Edward Kennedy.\0"
      "Der Ton zwischen beiden Parteien verschärfte sich jedoch im Sommer 2001 durch den Wechsel eines republikanischen Senators zu den Demokraten, was zu einem Verlust der republikanischen Senatsmehrheit führte und von zahlreichen Republikanern als Vertrauensbruch angesehen wurde.\0"
      "Wichtigste Gesetzesprojekte bis zum 11. September 2001 (dem Tag der Terroranschläge auf die Zwillingstürme des World Trade Centers, bekannt als 9/11) waren ein Programm zur massiven Senkung der Steuern und die Reform des Bildungswesens. Beide wurden vom Kongress angenommen. Der sogenannte No Child Left Behind Act (Kein Kind soll zurückbleiben), der die Qualität des öffentlichen Schulwesens, jedoch auch den Zugriff des Militärs auf Personalien der Schüler zum Zweck einer Rekrutierung verbessern sollte, trat im Januar 2002 in Kraft.\0"
      "Im März 2001 wurde der endgültige Ausstieg der Vereinigten Staaten aus dem Kyoto-Abkommen zur Reduzierung der Treibhausgase verkündet. Dieser Schritt stieß im In- und Ausland auf scharfe Kritik. In der Kontroverse um Ölbohrungen im Arctic National Wildlife Refuge drängte die Regierung Bush auf eine Aufhebung des dort bestehenden Förderverbotes für Erdöl.[2] Im August 2001 änderte George W. Bush seine Haltung in der Bioethik-Debatte, indem er sich für die – wenn auch eingeschränkte – Förderung der embryonalen Stammzellenforschung entschied.\0"
      "In den ersten Monaten seiner Präsidentschaft war Bush insgesamt relativ unauffällig, er verbrachte sehr viel Zeit auf seiner Ranch in Texas, was ihm den Ruf eines „Teilzeitpräsidenten“ einhandelte.\0"
      "Außenpolitik nach dem 11. September 2001\0"
      "Präsident Bush spricht zur Sicherheitspolitik am Mount Rushmore National Memorial (2002)\0"
      "Mit den Terroranschlägen vom 11. September 2001 erfuhr die Politik von George W. Bush einen tief greifenden Einschnitt. Angesichts der schockierend hohen Opferzahl und der medial stark transportierten symbolischen Wirkung der Anschläge rief er einen Krieg gegen den Terrorismus aus.\0"
      "Mit breiter internationaler Unterstützung (auch der deutschen Bundesregierung und vieler muslimischer Staaten) und der Zustimmung des Sicherheitsrates der Vereinten Nationen führten die Vereinigten Staaten und Großbritannien zunächst ab dem 7. Oktober Krieg in Afghanistan, wo die für die Anschläge verantwortlich gemachte Terrororganisation al-Qaida ihre Basis hatte.\0"
      "Ein weiteres Ziel war, das islamistische Regime der Taliban zu stürzen. Die Zahl der getöteten Zivilisten in diesem Krieg, bei dem auch sogenannte Daisy Cutter, Streubomben und Uranmunition zum Einsatz kamen, wurde von der Frankfurter Konferenz der europäischen Exil-Afghanen im Dezember 2001 auf etwa 18.000 geschätzt.\0"
      "Am 15. Juni 2002 hielt Präsident Bush eine Nahostrede, die neben der Forderung nach einer neuen palästinensischen Führung auch den Grundstein für den späteren gemeinsamen Friedensplan der Vereinigten Staaten, Russlands, der Europäischen Union und der Vereinte Nationen, der sogenannten Roadmap, enthielt. Dies war sein erstes wahrnehmbares Engagement in dem Konflikt, den er zuvor offenbar ignoriert hatte.\0"
      "Im Juli 2002 entschied sich Präsident Bush, eine vom Kongress bewilligte Finanzhilfe in Höhe von 34 Mio. USD für den Bevölkerungsfonds der Vereinten Nationen (UNFPA) zurückzuhalten, da dieser seiner Meinung nach in der Volksrepublik China Zwangsabtreibungen und -sterilisationen finanziere.\0"
      "Im August 2002 versuchte Bush, den neu errichteten Internationalen Strafgerichtshof zu schwächen. Bilaterale Abkommen mit anderen Staaten sollten Auslieferungen von Bürgern der Vereinigten Staaten nach Den Haag, dem Sitz des Gerichtshofs, verhindern; der American Servicemembers' Protection Act erlaubte dem Präsidenten stattdessen, deren gewaltsame Befreiung anzuordnen.\0"
      "Einen Monat später wurde die neue Nationale Sicherheitsstrategie veröffentlicht. Diese enthielt einige Änderungen der Politik der Vereinigten Staaten, die sie auch als Bush-Doktrin bekannt werden ließen. Der auffallendste Punkt war hierbei das explizite Zulassen von Präventivschlägen bei Bedrohung durch Massenvernichtungswaffen.\0"
      "Irakkrieg\0"
      "Bush mit Verteidigungsminister Donald Rumsfeld (Mitte) und dessen Stellvertreter Paul Wolfowitz 2003, zu Beginn des Irakkriegs\0"
      "Im Laufe des Jahres 2002 stellte Bush einen direkten Zusammenhang zwischen dem Krieg gegen den Terrorismus und Saddam Hussein her. Bush warf dem Irak zudem vor, er besitze Massenvernichtungswaffen. Der Vorwurf wurde schon damals skeptisch aufgenommen und ließ sich später nicht beweisen. Sein stetig wachsender Druck auf den Irak gipfelte schließlich im März 2003 im Irakkrieg mit der Invasion des Iraks durch britische und amerikanische Truppenverbände. Die Truppen des Irak wurden innerhalb weniger Wochen besiegt und das Land besetzt mit dem erklärten Ziel, dort Voraussetzungen für eine demokratische Regierung zu schaffen.\0"
      "Da wegen der starken Opposition im Sicherheitsrat der Vereinten Nationen das eigentlich gewünschte ausdrückliche UNO-Mandat nicht zu bekommen war, stützte er sich am Ende lediglich auf eine so genannte Koalition der Willigen aus Großbritannien, Spanien, Italien, Polen, Australien und etwa 30 weiteren Staaten. Die Gegner des Irakkrieges, darunter die Regierungen Frankreichs, Russlands, Deutschlands und Österreichs, sahen in einer Fortführung der Waffeninspektionen durch die Internationale Atomenergieorganisation (IAEO) ein angemesseneres, vorläufig ausreichendes Mittel für eine Abrüstung des Irak.\0"
      "Auch in der internationalen Öffentlichkeit war es zu Massenprotesten gegen die Außenpolitik der Vereinigten Staaten und ihrer Verbündeten gekommen. Weltweit beteiligten sich im Februar und März 2003 Millionen von Menschen an Antikriegsdemonstrationen der Friedensbewegung – auch in solchen Ländern, deren Regierungen sich hinter Bush gestellt hatten. Unter anderem wurde Bush vorgeworfen, dass der bedeutendere Kriegsgrund weniger der Kampf gegen den Terrorismus sei, sondern vielmehr die wirtschaftspolitischen (Zugriff auf die irakischen Erdölquellen) und geostrategischen Interessen der Vereinigten Staaten.\0"
      "Während der Krieg in Afghanistan im Allgemeinen durch das Recht auf Selbstverteidigung als gedeckt gilt, war die völkerrechtliche Legitimation des Irakkrieges von Anfang an stark umstritten.\0"
      "Die Kriegsgegner sehen sich inzwischen dadurch bestätigt, dass keinerlei Massenvernichtungswaffen gefunden werden konnten und der Terrorismus durch den Krieg nicht geschwächt wurde. Tatsächlich blieb der Irak – und mit ihm auch zunehmend der Großteil des nahen Ostens – nach dem offiziellen Kriegsende („mission accomplished!“) ein Unruheherd, in dem sich Anschläge gegen die Besatzungstruppen, gegen andere Ausländer und gegen mit ihnen zusammenarbeitende, aber auch völlig unbeteiligte irakische und arabische Zivilisten häufen. Auch international kam es zu weiteren Terroranschlägen, die al-Qaida und ihr nahestehenden Organisationen, zugeschrieben werden, darunter in Istanbul und am 11. März 2004 in Madrid.\0"
      "Einen weiteren Einschnitt erfuhr Bushs Außenpolitik im Frühjahr 2004 als Folge des Wahlsiegs der PSOE (Sozialisten) bei den spanischen Parlamentswahlen: Wenige Tage vor der Wahl waren bei einem Bombenanschlag auf Madrider Vorortzüge 191 Menschen ums Leben gekommen. Die amtierende Regierung Aznar versuchte zunächst, die mutmaßlich von al-Qaida-Terroristen verübten Anschläge, wider besseres Wissen, der baskischen Separatistenorganisation ETA zuzuschreiben. Die öffentliche Empörung darüber trug dann aber entscheidend zum überraschenden Wahlsieg des Sozialisten José Luis Rodríguez Zapatero bei. Wie im Wahlkampf angekündigt, ordnete der neue Ministerpräsident kurz nach seiner Vereidigung den Rückzug der spanischen Truppen aus dem Irak an, da er „keine Anzeichen dafür erkennen könne, dass die Truppen“, wie von ihm gefordert, „bis zum 30. Juni der UN unterstellt würden“. Damit scherte ein bislang als zuverlässig eingestufter Partner aus der „Koalition der Willigen“ aus.\0"
      "Im Mai 2004 drangen zunehmend Informationen über Praktiken teils systematischer Folter und Misshandlung irakischer Gefangener durch Angehörige amerikanischen Militärs im Bagdader Abu-Ghuraib-Gefängnis an die Öffentlichkeit. Die Folterungen wurden durch Fotos und Videos belegt. Bei den Misshandlungen hatte es auch schon mehrere Todesopfer gegeben. Bald wurden ähnliche Vorfälle auch in anderen von Amerikanern geführten Militärgefängnissen im Irak und in Afghanistan bekannt. Schon zuvor war die Bush-Regierung wegen der Behandlung der Gefangenen auf dem US-Stützpunkt Guantánamo Bay in Kuba in die Kritik geraten. Mit dem Bekanntwerden der Vorfälle in Abu Ghuraib weitete sich die Angelegenheit schnell zu einem Skandal aus, der die moralische Glaubwürdigkeit der Bush-Regierung deutlich schwächte.\0"
      "Im Dezember 2008 besuchte Bush den Irak und wurde vom Journalisten Muntazer al-Zaidi mit zwei Schuhen beworfen; das von diesem verwendete Modell fand bald darauf vorübergehend reißenden Absatz in aller Welt.\0"
      "Innenpolitik nach dem 11. September 2001\0"
      "Innenpolitisch konnte sich Bush infolge des allgemeinen Schocks durch die Anschläge zunächst auf eine breite Unterstützung im Kampf gegen den Terrorismus verlassen: Maßnahmen wie strengere Sicherheitskontrollen und Einreisebedingungen und Einschränkungen der Bürgerrechte durch den Patriot Act I konnten zügig und praktisch ohne öffentliche Auseinandersetzung verabschiedet werden. George W. Bush konnte die höchsten Zustimmungswerte verzeichnen, die jemals in den Vereinigten Staaten gemessen wurden. Erst später wurde Kritik hauptsächlich an den Plänen zu einem Patriot Act II laut. Unter Verweis auf die Terrorismusbekämpfung wurden diverse Institutionen wie der Zoll (CBP und ICE), die Küstenwache und die Katastrophenschutzbehörde Federal Emergency Management Agency in einem neuen Heimatschutzministerium mit zusammen 180.000 Mitarbeitern zusammengefasst.\0"
      "Im Namen des Heimatschutzministeriums unterzeichnete George W. Bush im Mai 2007 die National Security Presidential Directive 51 (NSPD 51), auch als Homeland Security Presidential Directive 20 (HSPD 20) bekannt, die im Falle einer nationalen Katastrophe oder Notfalls die Fortdauer der konstitutionellen Regierungsarbeit („Enduring Constitutional Government“) sicherstellen soll, indem der Präsident die Kooperation zwischen der Exekutive, der Legislative, und der Judikative koordiniert.[3]\0"
      "Mittlerweile wurde bekannt, dass sich das FBI und die National Security Agency (NSA) in einem an den Präsidenten gerichteten Memorandum schon im August 2001 mit der Terrorbedrohung für die Vereinigten Staaten befasst hatten; dies kam darin allerdings zu dem Schluss, dass es zwar „verdächtige Aktivitäten“ gäbe, sich Gerüchte über eine geplante Flugzeugentführung aber „nicht bestätigen“ ließen. Dieses bis dahin geheime Dokument wurde von der Regierung widerwillig und auf Druck der vom Kongress eingesetzten Untersuchungskommission im April 2004 veröffentlicht. Allerdings, so stellte sich schließlich heraus, waren die Warnungen und Hinweise des Memorandums sehr allgemein gehalten gewesen, weshalb konkrete Schutzmaßnahmen nicht möglich erschienen.\0"
      "Im März 2002 entschied Präsident Bush, Einfuhrzölle auf Stahlprodukte zu erheben, um amerikanische Firmen dieses Sektors vor ausländischer Konkurrenz zu schützen. In der Folge verhängte die Europäische Union, gebilligt von der WTO, Strafzölle gegen die Vereinigten Staaten.\0"
      "Im Jahre 2002 gewann die republikanische Partei die Senatswahlen und konnte, entgegen dem normalen Trend, dass die Regierungspartei in den Midterm Elections Stimmen verliert, ihre Mehrheit im Kongress ausbauen.\0"
      "Eine Gesetzesinitiative des Präsidenten, die durch Steuererleichterungen die Konjunktur ankurbeln sollte, gewann im Mai 2003 Gesetzeskraft.\0"
      "Im November 2003 gelang es Präsident Bush, eine Mehrheit für eine umfangreiche Gesundheitsreform mit Einführung staatlicher Zuschüsse für Medikamente im Rahmen der Medicare-Versicherung zu gewinnen.\0"
      "Im Januar 2004 kündigte Präsident Bush an, der Weltraumbehörde NASA Mittel für eine bemannte Station auf dem Mond zur Verfügung zu stellen, die als Bahnhof und Testlabor für spätere Flüge zum Mars dienen soll.\0"
      "Bushs demokratischer Herausforderer in der Wahl 2004, John Kerry, räumte unmittelbar nach der Wahl seine Niederlage ein, wobei sich diesmal Ohio als der am längsten zählende und wahlentscheidende Staat erwies. Bush hatte – aufgrund der für amerikanische Verhältnisse sehr großen Wahlbeteiligung – mehr Stimmen als jeder andere zuvor gewählte amerikanische Präsident auf sich vereinen können. Zum ersten Mal seit 1988 erhielt der Wahlsieger allerdings nicht nur die absolute Mehrheit der Wahlmännerstimmen, sondern auch die der abgegebenen Wählerstimmen. Gleichwohl gibt es Kritiker, u. a. den im Kampf um einen Parlamentssitz unterlegenen Demokraten Jeff Fisher, die behaupten, dass nur in Wahlbezirken, in denen elektronische Wahlmaschinen eingesetzt wurden, extreme Abweichungen (Unregelmäßigkeiten) vorgekommen seien. (Näheres im Hauptartikel zur Präsidentenwahl der Vereinigten Staaten, 2004)\0"
      "Ein US-Bundesgericht in Detroit hat erstmals am 17. August 2006 das umstrittene Abhörprogramm der Regierung für verfassungswidrig erklärt. Die Entscheidung der Richterin in Detroit stellt Beobachtern zufolge einen großen Rückschlag für Bush in dessen Kampf gegen den Terrorismus dar. Bush hatte das Abhörprogramm nach den Anschlägen vom 11. September 2001 unter Ausschluss der Öffentlichkeit genehmigt. Es erlaubt den Behörden, internationale Telefongespräche amerikanischer Bürger mitzuhören und auch E-Mails abzufangen, ohne dafür eine richterliche Genehmigung beantragen zu müssen. Das geheime Programm war 2005 aufgedeckt und daraufhin heftig kritisiert worden.\0"
      "Zweite Amtszeit als Präsident\0"
      "Bush mit Angela Merkel bei ihrem Antrittsbesuch\0"
      "Im Kabinett Bushs der zweiten Amtsperiode wurde etwa die Hälfte der Minister ausgetauscht. Außenminister Colin Powell, der schon im November seinen Rücktritt erklärt hatte, wurde durch Condoleezza Rice ersetzt.\0"
      "In der Ansprache seiner zweiten Amtseinsetzung im Januar 2005 erklärte Bush, dass es nun die Politik der Vereinigten Staaten wäre, Tyranneien auf der Welt zu beenden, und dass das Überleben der amerikanischen Freiheit von der Freiheit jedes anderen Landes abhänge.\0"
      "Anfang 2005 setzte Bush durch, dass der vormals stellvertretende Verteidigungsminister Paul Wolfowitz Präsident der Weltbank wurde. Am 1. August 2005 bestimmte er per Dekret den UNO-Kritiker John R. Bolton zum neuen UNO-Botschafter der Vereinigten Staaten. (Die Besetzung dieses Postens ist eigentlich zustimmungspflichtig durch den Senat, in der Sommerpause kann der Präsident dies unter bestimmten formalen Voraussetzungen umgehen.) Bolton war von der demokratischen Opposition sowie von Teilen der Republikaner abgelehnt worden.\0"
      "Am 29. August 2005 traf der Hurrikan Katrina auf die amerikanische Südküste und löste eine der verheerendsten Naturkatastrophen in der Geschichte der Vereinigten Staaten aus. Die Stadt New Orleans, die nur mangelhaft auf die Naturkatastrophe vorbereitet war, wurde überflutet. Etwa 1800 Menschen kamen ums Leben und der Sturm richtete Sachschäden im Wert von 81 Milliarden Dollar an. In diesem Zusammenhang erfuhr Bush heftige Kritik an seinem Vorgehen vor und nach der Katastrophe durch die amerikanischen Medien und viele Betroffene. Insbesondere wurde die Notfallplanung kritisiert, da es keine nationalen Evakuierungspläne gab und Bush eine Kongressstudie für den Schutz von Städten vor Hurrikanen der Stärke 5 auf Eis gelegt hatte. Die Haushaltsmittel für Katastrophen- und Heimatschutz wurden stattdessen teilweise für den Irakkrieg genutzt. Ebenso wurde ihm vorgeworfen, rechtzeitige Mahnungen zur Verstärkung der Deiche missachtet zu haben: Bush hatte den Chef der für den Deichbau zuständigen Behörde 2002 entlassen, nachdem dieser dem Kongress Pläne für ein 188 Millionen Dollar teures Flutungsprojekt am unteren Mississippi vorgelegt hatte. In Interviews Anfang September behauptete Bush hingegen: Niemand konnte den Bruch der Deiche voraussehen.[4]\0"
      "Zu Bushs bedeutenderen innenpolitischen Erfolgen in der zweiten Amtszeit gehören die Neubesetzungen zweier Sitze am mächtigen Supreme Court. Am 5. September 2005 nominierte er John G. Roberts junior zum Nachfolger als Chief Justice für den verstorbenen William H. Rehnquist. Nach dessen Bestätigung durch den Senat nominierte Bush am 3. Oktober 2005 seine Rechtsberaterin Harriet Miers als Nachfolgerin der zurückgetretenen Sandra Day O’Connor als Richterin am Obersten Gerichtshof der Vereinigten Staaten, zog dies aber nach außergewöhnlich starker Kritik aus allen politischen Lagern am 27. Oktober 2005 auf Miers’ Bitte hin zurück und nominierte stattdessen Samuel Alito, der am 31. Januar 2006 mit knapper Mehrheit vom Senat bestätigt wurde.\0"
      "Bush mit Vizepräsident Dick Cheney (2006)\0"
      "Ebenfalls im Oktober spitzte sich die sogenannte Plame-Affäre zu, bei der hochrangige Mitglieder der Bush-Regierung beschuldigt wurden, die Identität der CIA-Agentin und Frau des Bush-kritischen Diplomaten Joseph Wilson, Valery Plame an die Presse weitergegeben zu haben. Lewis Libby, Stabschef von Vizepräsident Richard Cheney, wurde unter anderem wegen Meineids und Behinderung der Justiz verhaftet. Weitere Beschuldigte sind Richard Cheney und Karl Rove, einer der wichtigsten Berater Bushs. Im April 2006 wurden dessen Aufgabenbereich als Berater verändert und ihm die Planung des Wahlkampfes der Kongresswahlen im November übertragen.\0"
      "In der seit 2006 in den Vereinigten Staaten heftig geführten Debatte um das Aufenthaltsrecht illegalisierter (hispanischer, zumeist mexikanischer) Einwanderer nimmt Bush eine eher liberale Haltung ein und befürwortet erleichterte Aufenthaltsbedingungen für bereits im Inland befindliche Einwanderer, überwiegend mit dem Hinweis, dass die Vereinigten Staaten ein traditionelles Einwanderungsland sind. Seine liberale Haltung in dieser Diskussion wird dabei von den Medien oft mit seiner Herkunft aus Texas, dem am stärksten mexikanisch geprägten Bundesstaat, in Zusammenhang gebracht. Bei neokonservativen Kreisen seiner Partei stößt diese Haltung auf bisweilen harsche Kritik. Gleichwohl unterzeichnet George W. Bush Ende Oktober 2006 ein Gesetz zum Ausbau der Grenze zu Mexiko, was von der mexikanischen Regierung massiv kritisiert wird.[5]\0"
      "George W. Bush war seit Jimmy Carter im Jahr 1979 der erste amerikanische Präsident, der Österreich besuchte; Bushs Besuch am 20. und 21. Juni 2006 führte ihn mit dem damals amtierenden EU-Ratspräsidenten und österreichischen Bundeskanzler Wolfgang Schüssel und mit Bundespräsident Heinz Fischer zusammen. Bei den Midterm-Elections 2006 erlitten die Republikaner unter Bush eine Niederlage und verloren sowohl die Mehrheit im Repräsentantenhaus als auch die Mehrheit im Senat. Das bestimmende Thema der Wahlen war der Irakkrieg. Nach der Wahl gab Bush den schon länger geplanten Rücktritt des Verteidigungsministers Rumsfeld bekannt und ernannte den CIA-Mann Robert Gates zu dessen Nachfolger.\0"
      "Im Sommer 2007 zogen sich mehrere hochrangige Mitarbeiter der Bush-Regierung zurück. Pressesprecher Tony Snow aus persönlichen Gründen, Karl Rove und der Justizminister Alberto R. Gonzales jedoch nach einer Affäre um die Entlassung zahlreicher Bundesanwälte, möglicherweise aus politischen Gründen. Im März 2008 legte Bush sein Veto gegen ein Gesetz ein, welches unter anderem die Anwendung der als Waterboarding bekannten Foltermethode durch die CIA verhindern sollte. Bush erklärte, dass die auf solche Weise erzielten Erfolge diese Art von Folter rechtfertigten. Gegen die Anwendung der Methode hatten sich zuvor auch ranghohe Militärs der Vereinigten Staaten gewandt.[6] Am 16. April 2008 feierte der Präsident zusammen mit Papst Benedikt XVI., der im Rahmen einer apostolischen Reise die Vereinigten Staaten besuchte, dessen 81. Geburtstag zusammen mit 9000 Gästen im Weißen Haus.\0"
      "Am 28. Juli 2008 stimmte er, als erster Präsident seit 51 Jahren, der Todesstrafe gegen einen verurteilten amerikanischen Militärangehörigen zu. [7]\0"
      "Die letzten Monate von Bushs Amtszeit wurden durch die internationale Finanzkrise überschattet, bei der bis zu seinem Ausscheiden aus dem Amt, viele Banken des Landes entweder in eine Schieflage gerieten oder sogar Konkurs anmelden mussten. Durch Bushs geschwächte Position im Kongress, musste er bei dem ersten Rettungspaket nicht nur um die Zustimmung der Demokraten, sondern auch bei seinen eigenen Parteifreunden um Billigung werben, die sich zunehmend wegen seiner Unpopularität von ihm distanzierten. Am 29. September 2008 scheiterte tatsächlich ein von Bush eingebrachtes Paket im Kongress, nicht zuletzt weil ihm auch einige Parteifreunde die Gefolgschaft versagten.[8]\0"
      "Irak\0"
      "Ein bestimmendes Thema der zweiten Amtszeit Bushs blieb der Irak, in dem 130.000 amerikanische und 20.000 britische Soldaten stationiert sind. Eine irakische Übergangsverfassung wurde verabschiedet, deren Ziel es war, einen demokratischen Bundesstaat zu bilden, in dem Kurden, Sunniten und Schiiten gemeinsam leben könnten. Anfang Januar 2005 wurde von den Irakern eine Übergangsregierung gewählt und im Oktober über eine neue Verfassung abgestimmt.\0"
      "Seit dem offiziellen Ende der Kampfhandlungen kam es im Irak zu ständigen terroristischen Angriffen und seit 2006 zu bürgerkriegsähnlichen Zuständen mit Kämpfen zwischen Schiiten und Sunniten. Seit Kriegsende sind zehntausende Iraker und über 1000 amerikanische Soldaten gewaltsam ums Leben gekommen. Bushs Politik änderte sich dadurch jedoch nicht. Die demokratische Opposition konnte sich nicht auf einen gemeinsamen Alternativvorschlag einigen, allerdings wuchs in Anbetracht der wachsenden Ausgaben für den Krieg, der getöteten Amerikaner und der dadurch erzwungenen militärischen Handlungsunfähigkeit in anderen Konflikten wie mit Iran oder Nordkorea, die Kritik.\0"
      "Im März 2006 setzte der Kongress die Baker-Kommission ein, eine zehnköpfige Gruppe um den ehemaligen Außenminister James Baker, um eine neue Strategie für den Irak zu erarbeiten. Diese legte im Dezember ihre Vorschläge vor, u.A. einen Abzug aller Kampftruppen aus dem Irak bis 2008. Die demokratische Opposition, die die Midterm-Elections gewonnen hatten, forderte danach eine Änderung der Strategie mit Abzug der amerikanischen Truppen. Am 11. Januar 2007 stellte Bush dann seine neue Irak-Strategie vor, die sogenannte \"Surge\". Diese ließ die Vorschläge der Kommission und die Forderungen der Opposition unberücksichtigt und hatte die Entsendung von 21.000 weiteren Soldaten zum Inhalt, um die Situation zu befrieden. Ein Abzug sollte sich anschließen, sobald die irakische Regierung alleine in der Lage seien, für Stabilität zu sorgen.\0"
      "Bush und Europa\0"
      "George W. Bush und Wladimir Putin in Kennebunkport, Maine, im Juli 2007\0"
      "Das Verhältnis der meisten europäischen Regierungen zur Regierung Bush war, teils infolge des neokonservativen Paradigmas seiner Politik und seines Werdegangs, belastet. Neben der spanischen unter Zapatero und der italienischen unter Romano Prodi galt dies ebenso für die französische Regierung unter Chirac. So haben die Wahlsieger Zapatero und Prodi die Irak-Kontingente ihrer Länder in Ablehnung des Irakkrieges unmittelbar nach ihrem jeweiligen Regierungswechsel aus dem arabischen Land abgezogen.\0"
      "Auch das Verhältnis Bushs zum ehemaligen deutschen Bundeskanzler Gerhard Schröder war wegen dessen ablehnender Haltung zum Irak-Engagement beeinträchtigt, dies galt jedoch nicht für die Beziehungen der Länder untereinander insgesamt. Schröders Nachfolgerin, Bundeskanzlerin Angela Merkel, hat sich erfolgreich um ein besseres Verhältnis bemüht. Gleichwohl stand Mitte 2006 die deutsche Bevölkerung der Person Bush und dessen Regierung mehrheitlich unverändert reserviert gegenüber. Im Vergleich zu Bush genießt der vorherige Präsident Clinton heute nach wie vor wesentlich höhere Sympathiewerte in Europa.\0"
      "Kritik und polarisierende Wirkung\0"
      "Bushkritische Hausbedachung an der Wienzeile\0"
      "Die Politik der amerikanischen Regierung unter George W. Bushs Präsidentschaft führte zu einer starken Polarisierung zwischen Befürwortern und Kritikern.\0"
      "Darüber hinaus werden Persönlichkeit und Eigenschaften der Person George W. Bush von Anhängern und Gegnern meist sehr gegensätzlich eingeschätzt. Während die einen seinen Glauben an Gott und die Führungsrolle der Vereinigten Staaten als Stärken schätzen, weisen die anderen auf seine denkwürdige Biographie, u.A. mit Hinweis auf seine früheren Alkoholprobleme, seiner selbsterklärte „Wiedergeburt“ als Christ und Anti-Alkoholiker und starke sprachlichen Unsicherheiten (siehe auch Bushism).\0"
      "Angeblich äußerte Bush nach Angaben des britischen Guardians 2003 gegenüber hochrangigen palästinensischen Politikern, dass er im Auftrag Gottes gehandelt habe, als er den so genannten Krieg gegen den Terrorismus begann, insbesondere mit Bezug auf die Invasion im Irak. Dieses Zitat wird von Vertretern des Weißen Hauses dementiert. Nach BBC-Angaben hat der ehemalige palästinensische Außenminister Nabil Schaath diese Äußerungen zwei Jahre später bestätigt.\0"
      "Während eine große Zahl der Mainstream-Medien im Zuge der Attentate vom 11. September 2001 die Regierungslinie vertraten, die auch über das Konzept des sogenannten eingebetteten Journalismus als Berichterstatter im anschließenden Irakkrieg weitgehend aufgingen, riefen die Ereignisse im Zuge der umstrittenen Wahl 2000, noch mehr aber in der Folge der Verschärfung der unilateralistischen Politik der Vereinigten Staaten in der Folge der Terroranschläge am 11. September 2001 zahlreiche Kritiker auf den Plan. Der Dokumentarfilmer Michael Moore erlangte dabei mit seinen Büchern Stupid White Men und Volle Deckung, Mr. Bush sowie mit seinem Film Fahrenheit 9/11 einen beträchtlichen Bekanntheitsgrad als Bush-Kritiker.\0"
      "George W. Bush ist der erste amerikanische Präsident, dessen Handeln die Produktion und Veröffentlichung eines großen Kinofilms (Fahrenheit 9/11), den Start eines gesamten Rundfunknetzes (Air America Radio) und die Premiere einer Fernsehserie (The Al Franken Show) bewirkte, deren gemeinsames Ziel es war, seine Wiederwahl zu verhindern.\0"
      "Bush ist außerdem noch der erste Präsident, der eine Nominierung (am 26. Februar 2005) und anschließend den Filmpreis Goldene Himbeere der Golden Raspberry Award Foundation als schlechtester Hauptdarsteller erhalten hat. Natürlich spielte er in Fahrenheit 9/11 rein technisch gesehen keine Rolle, sondern wurde nur in Archivaufnahmen gezeigt. Es ist anzunehmen, dass die Verleihung des Preises in diesem Fall als politische Stellungnahme der Jury zu betrachten ist.\0"
      "Im Dezember 2004 wählt das Time Magazine ihn zur Person des Jahres 2004 „for sharpening the debate until the choices bled, for reframing reality to match his design, for gambling his fortunes – and ours – on his faith in the power of leadership“ (frei übersetzt: „dafür, die Debatte zuzuspitzen bis Wahlmöglichkeiten hervorsprudelten, dafür, die Realität umzudeuten um seinen Vorstellungen zu entsprechen, dafür seine - und unsere - Geschicke aufs Spiel zu setzen, mit seinem Glauben an die Kraft durch Führerschaft“).\0"
      "Der Freedom of Information Act ist in den Vereinigten Staaten seit den Terroranschlägen vom 11. September 2001 stark beschnitten worden. Immer mehr Regierungsakten werden mit dem Vermerk „Geheim“ oder einfach „Nur für den Dienstgebrauch“ versehen und damit umfassender Transparenz entzogen.\0"
      "Ex Präsident George W. Bush und Laura Bush fliegen am 20. Januar 2009 mit der VC-25 nach Dallas.\0"
      "Staatsbesuche Bushs besonders in europäischen Ländern führten immer wieder zu Demonstrationen gegen seine Außenpolitik, insbesondere den Irakkrieg und das Internierungslager Guantánamo. So kam es Anfang Juni 2004 bei einer Europareise Bushs anlässlich des 60. Jahrestags der Invasion der Alliierten in der Normandie beim Staatsbesuch in Italien zu massiven Straßenprotesten in Rom gegen Bush. Dort wurde der Präsident auch von Papst Johannes Paul II. zu einer Audienz empfangen. Der Papst, ebenfalls ein entschiedener Gegner des Irakkrieges, kritisierte Bushs Irak-Politik mit ungewohnt deutlichen Worten und forderte ihn zu einer Veränderung seiner entsprechenden Politik auf.\0"
      "Belastet waren auch die auswärtigen Beziehungen der Regierung Bush zu einigen mittel- und südamerikanischen Regierungen, etwa der von Hugo Chávez in Venezuela.\0"
      "Klimawandel\0"
      "Die Regierung Bush hat die Unterdrückung missliebiger Umweltberichte vorangetrieben. Auf kritische Berichte über den Klimawandel wurde Einfluss genommen, etwa indem Wissenschaftler zu einer Vermeidung der kritischen Passagen aufgefordert wurden. Auch Kontakte zu Medien wurden reglementiert. Darüber beklagt hatte sich die Hälfte von 300 zu diesem Thema befragten Wissenschaftlern.[9]\0"
      "Nach der Präsidentschaft\0"
      "Nach der Amtseinführung von Barack Obama kündigte Bush an, sich in Preston Hollow in der Nähe von Dallas, Texas, mit seiner Frau Laura niederzulassen. Während eines Fernsehinterviews am 17. März 2009 sagte er, dass er an einem Buch schreibe, das unter dem Namen Decision Points im Jahr 2010 erscheinen soll [10].\0"
      "Verfilmung\0"
      "Regisseur Oliver Stone und Drehbuchautor Stanley Weiser erarbeiteten eine Filmbiografie von Präsident Bush: „W. – Ein missverstandenes Leben“ hatte am 17. Oktober 2008 in den Vereinigten Staaten Premiere. George W. Bush wird von Josh Brolin und Laura Bush von Elizabeth Banks gespielt.\0"
      "Trivia\0"
      "2005 wurde der Schwammkugelkäfer Agathidium bushi, der sich von Schleimpilzen ernährt, nach ihm benannt.[11]"
      ;
    compare (string, sizeof (string) - 1, 1000);
    compare (string, sizeof (string) - 1, 1000);
    compare (string, sizeof (string) - 1, 1000);
  }

  return 0;
}
