%{
// bugfilter.ll
//
//	Filter for CVS check in messages.  This creates bug fixed and
//	applied change set records.
//
#define YY_SKIP_YYWRAP
#include <strstream.h>
#include "bug_type.h"

static bool yywrap() { return true; }

static bug_list * bl_val;

%}

IDVAL		[0-9]+
CHGSET		([0-9a-f]{32})

%%
[aA][pP][pP][lL][iI][eE][dD]([ \t\n]+)/{CHGSET}	{ bl_val->has_applied = true; }
{CHGSET}						{ bl_val->add_changeset_applied( yytext ); }
[fF][iI][xX]([eE][dD])?			{ bl_val->state = bug_type::FIXED; }
[pP][aA][rR][tT]([iI][aA][lL])?	{ bl_val->state = bug_type::PARTIAL; }
[rR][eE][lL][aA][tT][eE][dD]	{ bl_val->state = bug_type::RELATED; }
[bB][uU][gG]{IDVAL}				{ bl_val->add_bug( yytext ); }
[cC][hH][gG]{IDVAL}				{ bl_val->add_bug( yytext ); }
[rR][eE][qQ]{IDVAL}				{ bl_val->add_bug( yytext ); }
[bB][uU][gG]([sS])?:			{ bl_val->expect_bugs = true; };
[dD][eE][sS][cC]([rR][iI][pP][tT][iI][oO][nN])?: { bl_val->expect_bugs = false; }
[nN][oO][tT][eE]([sS])?			{ bl_val->expect_bugs = false; }
.
"\n"
%%

void parse_bugs( bug_list * bl, const char * str, int len )
{
	bl_val = bl;
	istrstream	strmstr( str, len );
	yyFlexLexer	lexer( & strmstr, 0 );
	while(lexer.yylex() != 0);
}
