#!/usr/bin/env python

import argparse

SECTOR_SIZE=512

def generate_image(image_filename, size_in_sectors):
    """ Generates binary image with sector-sized block.
        Each block contains ASCII string with this sector number.
    """
    fp = open(image_filename, 'wb')
    for i in range(0, size_in_sectors):
        # write sector number in ASCII form at beginning of each sector
        data = "\nsector: %d\n" % i
        # fill with spaces the rest of sector
        data = data.ljust(SECTOR_SIZE)
        fp.write(data)
    fp.close()


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--image-file', help="Filename for generated image file", action='store', dest='image', required=True)
    parser.add_argument('--size-in-sectors', help="Size of resulting image in sectors", action='store', dest='sectors', type=int, required=True)
    args = parser.parse_args()

    generate_image(args.image, args.sectors)
