function [links, nodes, A] = constructLinks(nodes,options)
% options.Rmax = inf -> constructs a fully connected network
% otherwise, only nodes closer than Rmax are connected.
N = nodes.N;
[nodes.outgoing{N}] = deal([]);
counter = 0;
for node=1:N
    for neighbor=node+1:N
        dist = norm(nodes.pos(:,node)-nodes.pos(:,neighbor));
        if dist<=options.Rmax
            counter = counter + 1;
            links.id(counter) = counter;
            links.start_node(counter) = node;
            links.end_node(counter) = neighbor;
            links.origin(:,counter) = nodes.pos(:,node);
            links.end(:,counter) = nodes.pos(:,neighbor);
            nodes.outgoing{node} = [nodes.outgoing{node}, counter];
            A(node,counter) = 1;
            A(neighbor,counter) = -1;
            % the link that goes other way
            counter = counter + 1;
            links.id(counter) = counter;
            links.start_node(counter) = neighbor;
            links.end_node(counter) = node;
            links.origin(:,counter) = nodes.pos(:,neighbor);
            links.end(:,counter) = nodes.pos(:,node);
            nodes.outgoing{neighbor} = [nodes.outgoing{neighbor}, counter];
            A(node,counter) = -1;
            A(neighbor,counter) = 1;
        end
    end
end
% if all the nodes are far apart, this means A is never created
if ~exist('A','var')
    A = [];
end

L = size(A,2);
links.L = L;
if (L>0) && (size(A,1) < N)
    % the last node(s) happen to be unconnected
    del = N - size(A,1);
    A = [A;zeros(del,L)];
end
