function displayLinks2(nodes,links,dests,options)

figure;
x = nodes.pos(1,:);
y = nodes.pos(2,:);
scatter(x,y,40,'b');
axis equal
hold on;
for ii=1:nodes.N
    t = text(x(ii)+.1,y(ii)+.1,int2str(nodes.id(ii)));
    set(t,'color','r');
end
for ii=1:links.L
    if links.rates(ii) == 0 continue; end;
    weight = find(links.rates(ii) == options.availRates);
    s = links.origin(:,ii);
    e = links.end(:,ii);
    tmp = [s,e];
    pp = plot(tmp(1,:),tmp(2,:),'g');
    set(pp,'linewidth',weight);
    u = e-s;
    tmp = s + u/2;
    t = text(tmp(1),tmp(2),num2str(links.rates(ii)/1e6));
    set(t,'color','b');
    u = u/norm(u);
    %v = [0,-1;1,0]*u;
    tmp = s + u;% + v/10;
    t = text(tmp(1),tmp(2),int2str(links.id(ii)));
    set(t,'color','c');
end
%return;
sinks = dests.nodes;
sources = dests.sources.id;
x1 = nodes.pos(1,sources);
y1 = nodes.pos(2,sources);
x2 = nodes.pos(1,sinks);
y2 = nodes.pos(2,sinks);
for dd = 1:dests.D
    p = plot_arrow(x1(dd),y1(dd),x2(dd),y2(dd),'headwidth',0.03,'headheight',0.06 );
    set(p(1),'LineStyle','-.');
    set(p(1),'Color','r');
end

