function [Z,fval] = solve_opt(options,links,dests,nodes,obj)

% I assume z = Z(:), that is Z is links.L x dests.D, z is LD x 1

N = options.N;
L = links.L;
F = dests.D;

Aeq = sparse(N*F,L*F);
offi = 0;
offj = 0;
[ii jj] = find(links.A);
for ff = 1:F
    Aeq(ii+offi,jj+offj) = links.A(ii,jj);
    offi = offi + N;
    offj = offj + L;
end
beq = sign(dests.Y(:));

% The following is when z^(1) + z^(2)+...+z^(F) <= links.rates
%A = sparse(repmat(eye(L),1,F));
%b = links.rates.'/options.Rate;

A = sparse(eye((L*F)));
b = repmat(links.rates.'/options.Rate,F,1);

ctype = repmat('S',N*F,1);
ub = repmat(links.rates.'/options.Rate,F,1);
vartype = repmat('B',L*F,1);


f = repmat(obj,F,1); %%% IF WE CAN COMBINE THE PACKETS, THE TOTAL 
%%% POWER WILL BE LESS THAN THIS

disp(sprintf('Solver: %s\n',options.solver));

switch lower(options.solver)
    case 'bintprog'
        [z,fval,exitflag] = bintprog(f,A,b,Aeq,beq);
    case 'glpk'
        [z,fval,status,extra] = glpk(f,Aeq,beq,[],ub,ctype,vartype);
        if (any(z>ub))
            warning('The solution found by glpk does NOT statisfy the UB constraint');
            disp(sprintf('status: %d\n', status));
        end
    otherwise
        error('Unknown solver');
end


Z = reshape(z,L,F);

for ff=1:F
    ll = links;
    ll.rates(~Z(:,ff)) = 0;
    displayLinks2(nodes,ll,dests,options);
end