#include "LinuxTest.h"

#include <AppKit/GSHbox.h>
#include <AppKit/GSVbox.h>


@implementation LinuxTest
{
  // See the @interface declaration in LinuxTest.h 
  // for the listing of instance variables
}
//
// Methods implementation
//

// Initialize an instance object of our class. 
- (id) init
{
  GSVbox* windowVbox;
  GSVbox* formVbox;
  GSHbox* hbox;

  NSRect winFrame;
  int i;
  NSSize size;
  NSScrollView *scView;

  self = [super init];

  // Create a vertical box (NB: Things are packed in the box 
  // from bottom to top)
  windowVbox = AUTORELEASE ([GSVbox new]);
  [windowVbox setBorder: 0];
  [windowVbox setDefaultMinYMargin: 0];
  
  //
  // Result field
  //
  hbox = AUTORELEASE ([GSHbox new]);
  [hbox setDefaultMinXMargin: 10];
  [hbox setBorder: 10];

  [hbox setAutoresizingMask: NSViewWidthSizable];
  [windowVbox addView: hbox];
  scView = [[NSScrollView alloc] initWithFrame:NSMakeRect(0,0,640.0f,240.0f)];
  tv = [[TestView alloc] initWithFrame:NSMakeRect(0,0,1200.0f,200.0f)];
  [scView setHasHorizontalScroller: YES];
  [scView setDocumentView:tv];
  [windowVbox addView: scView];

  //
  // Separator
  //
  [windowVbox addSeparator];
  
  //
  // Upper part of the window
  //
  formVbox = AUTORELEASE ([GSVbox new]);
  [formVbox setBorder: 10];
  [formVbox setDefaultMinYMargin: 10];


  [formVbox setAutoresizingMask: NSViewWidthSizable];
  [windowVbox addView: formVbox];

  //
  // Window
  //
  winFrame.size = [windowVbox frame].size;
  winFrame.origin = NSMakePoint (300, 150);

  // Now we can make the window of the exact size  
  // NB: Note that we do not autorelease the window
  window = [[NSWindow alloc] 
	     initWithContentRect: winFrame
	     styleMask: (NSTitledWindowMask | NSMiniaturizableWindowMask 
			 | NSResizableWindowMask)
	     backing: NSBackingStoreBuffered
	     defer: YES];
  [window setTitle: @"LinuxTest.app"];
  [window setContentView: windowVbox];
  [window setMinSize: [NSWindow frameRectForContentRect: winFrame
				styleMask: [window styleMask]].size];

  // Trick to forbid vertical resizing
  [window setResizeIncrements: NSMakeSize (1, 100000)];
  return self;
}
- (void)dealloc
{
  // Releasing the window releases all its views in cascade
  RELEASE (window);
  [super dealloc];
}

- (void)applicationDidFinishLaunching: (NSNotification *)aNotification;
{
  [window orderFront: self];
}

// Execution starts from here. 
int main (void)
{
   NSAutoreleasePool *pool;
   NSApplication *app;
   NSMenu *mainMenu;
   NSMenu *menu;
   NSMenuItem *menuItem;
   LinuxTest *lTest;
   int i;

   // We need to explicitly create this object only in the main function;     
   // instead, while the app is running, the gui library creates these objects
   // automatically for us.
   pool = [NSAutoreleasePool new];

   // Get the object representing our application.
   app = [NSApplication sharedApplication];
  
   //
   // Create the Menu 
   //

   // Main Menu
   mainMenu = AUTORELEASE ([NSMenu new]);

   // Info Item
   // The object receiving this message is determined at run time;
   // it will be the NSApplication
   [mainMenu addItemWithTitle: @"Info..." 
	     action: @selector (orderFrontStandardInfoPanel:) 
	     keyEquivalent: @""];

   // Edit Submenu
   menuItem = [mainMenu addItemWithTitle: @"Edit" 
			action: NULL 
			keyEquivalent: @""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu: menu forItem: menuItem];

   // The object which should receive the messages cut:, copy:, paste: is not 
   // specified, so that the library will have to determine it at run time. 
   // At first, it will (try to) send them to the 'first responder' 
   // -- the object which is receiving keyboard input.  
   // In our case that is precisely what we want, since the first responder 
   // is the NSText being edited (which knows how to handle cut:, copy:, 
   // paste:), if any.  
   [menu addItemWithTitle: @"Cut" 
	 action: @selector (cut:) 
	 keyEquivalent: @"x"];

   [menu addItemWithTitle: @"Copy" 
	 action: @selector (copy:) 
	 keyEquivalent: @"c"];

   [menu addItemWithTitle: @"Paste" 
	 action: @selector (paste:) 
	 keyEquivalent: @"v"];

   [menu addItemWithTitle: @"SelectAll" 
	 action: @selector (selectAll:) 
	 keyEquivalent: @"a"];

   // Hide MenuItem
   [mainMenu addItemWithTitle: @"Hide" 
	     action: @selector (hide:) 
	     keyEquivalent: @""];
   // Quit MenuItem
   [mainMenu addItemWithTitle: @"Quit" 
	     action: @selector (terminate:)
	     keyEquivalent: @"q"];	

   [app setMainMenu: mainMenu];

      [mainMenu setTitle: @"SndView"];


   // Create and initializes an instance of our custom object.
   lTest = [[LinuxTest alloc] init];
   
   // Set our custom object instance as the application delegate. 
   // This means that 'converter' will receive certain messages 
   // (documented in the doc) before/after important events for the app 
   // life, such as starting, ending, closing last window, etc.
   // In this context, we are interested in receiving the 
   // [-applicationDidFinishLaunching:] message.
   [app setDelegate: lTest];

   // Finally, all is ready to run our application.
   [app run];
   return 0;
}


