// comment the following line out and recompile, to see the bug in action.
#define WORKAROUND_GNUSTEP_SCROLLING_BUG

#import "TestView.h"


@implementation TestView
#define ceil safeceil
inline int safeceil(double num) {
  if ((int)num == num) return num;
  if (num > 0) return (int)num + 1;
  return (int)num;
}


+ (void)initialize
{
  if (self == [TestView class])
  {
      (void)[TestView setVersion: (int)0];
  }
  return;
}
- (id)initWithFrame:(NSRect)aRect
{
	[super initWithFrame:aRect];
	selectionRect = NSMakeRect(0.0,0.0,0.0,00.0);
    reductionFactor = 1.0; /* bogus */

    svFlags.disabled=0;
    svFlags.continuous=0;
    svFlags.cursorOn=0;
    svFlags.drawsCrosses = 1;
    svFlags.autoscale=0;
    svFlags.bezeled=0;
    svFlags.notEditable=0;
    svFlags.notOptimizedForSpeed=0;
	return self;
}

- (BOOL)isOpaque
{  return YES;	}

- (void)drawRect:(NSRect)rects
{
    NSRect newRect,insetBounds,scaledSelRect;
	NSRect bounds = [self bounds];
	[[NSColor whiteColor] set];
	NSRectFill(rects);
	[[NSColor blackColor] set];
	PSsetlinewidth(0.0);
	PSmoveto(NSMinX(bounds),NSMinY(bounds));
	PSlineto(NSMaxX(bounds),NSMaxY(bounds));
	PSstroke();
    scaledSelRect = selectionRect;
    scaledSelRect.origin.x = (int)((float)NSMinX(selectionRect) / (float)reductionFactor);
    scaledSelRect.size.width = (int)((NSMaxX(selectionRect) - 1) / reductionFactor)
                  - NSMinX(scaledSelRect) + 1;

    if (!((NSMinX(scaledSelRect) >= NSMinX(rects) && NSMinX(scaledSelRect) <= NSMaxX(rects)) ||
        (NSMaxX(scaledSelRect) >= NSMinX(rects) && NSMaxX(scaledSelRect) <= NSMaxX(rects)) ||
        (NSMinX(scaledSelRect) <= NSMinX(rects) && NSMaxX(scaledSelRect) >= NSMaxX(rects))
        ))
            return;
    else {
        NSRect highlightRect = [self bounds];
//		printf("HIGHLIGHTing scaled sel rect... %g to %g\n",NSMinX(scaledSelRect),NSMaxX(scaledSelRect));
//		printf("HIGHLIGHTing rects... %g to %g\n",NSMinX(rects),NSMaxX(rects));
        highlightRect.origin.x = (int)((NSMinX(scaledSelRect) >= NSMinX(rects)) ?
                        NSMinX(scaledSelRect) : NSMinX(rects));

        highlightRect.size.width = (int)(((NSMaxX(scaledSelRect) <= NSMaxX(rects)) ?
                        NSMaxX(scaledSelRect) :
                        NSMaxX(rects) )   - NSMinX(highlightRect) + 0.1);

        NSHighlightRect(highlightRect);
//		printf("HIGHLIGHT %g to %g\n",NSMinX(highlightRect),NSMaxX(highlightRect));
    }
}

- (void)mouseDown:(NSEvent *)theEvent 
{
    NSPoint		mouseDownLocation, /*mouseUpLocation,*/ mouseLocation,timerMouseLocation;
    NSRect		visibleRect, adjSelRect;
    NSPoint		selPoint;
    float		oldx=0, dx=0;
    NSEvent *event;
    BOOL timer = NO;
    BOOL useTimerLocation = NO;
    BOOL		scrolled = NO;
    int 		hilStart=-1,hilEnd=-1; /* which pixels are currently highlighted */
    int			realStart = ((float)NSMinX(selectionRect) + .1);
    int			realEnd = ((float)NSMaxX(selectionRect) + .1) - 1;
    BOOL		direction;
	
	/* in order to preserve the start and end points of a selection when
	 * only the 'other' end is moved, we keep the original values here.
	 * This is important because the original endpoints may not lie on
	 * pixel boundaries when reductionFactor > 1.
	 * When we are about to change the endpoints, we check to see if the
	 * 'changed' start or end has moved away from the original value. If so,
	 * we discard the remembered value. If not, we keep it.
	 */
	
	[self hideCursor];
    [[self window] makeFirstResponder:self];

	    [self lockFocus];

  /* we're now interested in mouse dragged events */

    [[self window] setAcceptsMouseMovedEvents:YES];

    
    mouseDownLocation = [theEvent locationInWindow];
    mouseDownLocation = [self convertPoint:mouseDownLocation fromView:nil];
    mouseLocation.x--;
    oldx = mouseDownLocation.x;
//	printf("Converted mouse location - 1 = %g\n",oldx);
    adjSelRect = selectionRect;
    adjSelRect.origin.y = NSMinY([self bounds]);
    adjSelRect.size.height = NSHeight([self bounds]);

    if (!([theEvent modifierFlags] & NSShiftKeyMask)) {
        realStart = realEnd = -1; /* we don't need to remember the old selection */
        adjSelRect.origin.x = (int)((float)NSMinX(adjSelRect) / (float)reductionFactor);
        adjSelRect.size.width = ((int)((float)NSMaxX(selectionRect) - 0.9) /
                (float)reductionFactor);

        if ((int)adjSelRect.size.width == ceil(adjSelRect.size.width))
                adjSelRect.size.width += 1;
        else adjSelRect.size.width = ceil(adjSelRect.size.width);
        adjSelRect.size.width -= NSMinX(adjSelRect);

        if (NSWidth(selectionRect) > 0.1) {
                NSHighlightRect(adjSelRect);/* to zap current selection */
			printf("zapping %g to %g\n",NSMinX(adjSelRect),NSMaxX(adjSelRect));
                selectionRect = NSMakeRect(mouseDownLocation.x, 0.0, 0.0, 0.0);
                }
	}
	else {/* if zero selection, (insertion point) what do we do? */
            if (NSWidth(selectionRect) > 0.1) {
                hilStart = ((int)((float)NSMinX(selectionRect) + 0.01) / reductionFactor);
                hilEnd = (((int)((float)NSMaxX(selectionRect) + 0.01) - 1) / reductionFactor);
                if (oldx < (hilStart + hilEnd) / 2) oldx = hilStart;
                else oldx = hilEnd + 1;
//			printf("extending selection\n");
		}
            else {
                if (oldx < ((float)NSMinX(selectionRect) / (float)reductionFactor))
                        oldx = (int)((float)NSMinX(selectionRect) / (float)reductionFactor) + 1;
                else oldx = (int)((float)NSMinX(selectionRect) / (float)reductionFactor);
			printf("zero selection, extending\n");
            }
	}
        event = theEvent;
        while ([event type] != NSLeftMouseUp) {
            visibleRect = [self visibleRect];

            if (!useTimerLocation) mouseLocation = [event locationInWindow];
            else mouseLocation = timerMouseLocation;
            mouseLocation = [self convertPoint:mouseLocation fromView:nil];

            selPoint = mouseLocation;
                    /* selFrame needs to be 'correct' for scrolling
                    * but actual selection is -1
                    */
            mouseLocation.x--;
            if (mouseLocation.x < -1) {
                mouseLocation.x = -1;
                selPoint.x = 0;
                            }
            if (selPoint.x >= NSMaxX([self bounds])) {
                selPoint.x = (int)NSMaxX([self bounds]);
                mouseLocation.x = selPoint.x - 1;
    //			printf("max'd mouseLocation: %g\n",mouseLocation.x);
                            }

                            /*
                            * make sure the selection will be entirely visible
                            */
            if (!NSPointInRect(selPoint , visibleRect) && (selPoint.x != NSMaxX(visibleRect))) {	
                [[self window] disableFlushWindow];
                [self scrollPointToVisible:selPoint];
    //			printf("scrolled to: %g %g\n",selPoint.x, selPoint.y);
    //			printf("visibleRect: %g %g %g %g\n",NSMinX(visibleRect), NSMinY(visibleRect), NSWidth(visibleRect), NSHeight(visibleRect));
                [[self window] enableFlushWindow];

                            /*
                            * note that we scrolled and start generating timer events for
                            * autoscrolling
                            */
                scrolled = YES;
                startTimer(timer);
                } else {
                            /* no scrolling, so stop any timer */
                    stopTimer(timer);
                    }

            dx = mouseLocation.x - oldx + 1;
            direction = (dx > 0);
            adjSelRect.origin.x = mouseLocation.x - dx + 1;
            if (dx < 0) {
                dx = -dx;
                adjSelRect.origin.x -= dx;
                            }
            adjSelRect.size.width = dx;
			printf("highlighting/unhighlighting following range: %g %g\n",NSMinX(adjSelRect),NSWidth(adjSelRect));
            if (dx) {
#ifdef WORKAROUND_GNUSTEP_SCROLLING_BUG
				[self unlockFocus];
				[self lockFocus];
#endif
				NSHighlightRect(adjSelRect);
				}
            if (NSMinX(adjSelRect) < 0) {
                adjSelRect.size.width += NSMinX(adjSelRect);
                adjSelRect.origin.x = 0;
                            }
            if (dx) {
                if (hilStart == -1) {
//				printf("(0)");
                    hilStart = NSMinX(adjSelRect);
                    hilEnd = (float)NSMaxX(adjSelRect) - 1.0;
                    }
                else if (NSMinX(adjSelRect) < hilStart) { /* new start point. need to adjust end? */
                                    /* if endpoint of selection is within current sel, we must have
                                    * backtracked right over the current selection, highlighting a new portion,
                                    * but unhighlighting the latter parts of the old selection.
                                    */
    //				printf("(1)");
                    if (NSMaxX(adjSelRect) - 1 >= hilStart) hilEnd = hilStart - 1;
                    hilStart = NSMinX(adjSelRect);
                    }
                else if (NSMaxX(adjSelRect) > hilEnd + 1) {/* tack on new addition to selection */
    //				printf("(2)");
                    if (NSMinX(adjSelRect) <= hilEnd) hilStart = hilEnd + 1;
                    hilEnd = NSMaxX(adjSelRect) -1;
                    }
                else if (NSMinX(adjSelRect) <= hilEnd && NSMinX(adjSelRect) >= hilStart) {
                                    /* we have shortened selection, by backtracking from end */
                    if (!direction) {
					printf("(3)");
                        hilEnd = NSMinX(adjSelRect) - 1;
                                        }
                    else { /* shorten selection by forward tracking from start */
    					printf("(4)");
                        hilStart = NSMaxX(adjSelRect);
                    }
                    if (hilEnd < hilStart) {/* printf("(5)"); */ hilStart = hilEnd = -1; } /* empty selection */
                }
    				else printf("(6)");
                if (hilStart != -1) {
    				printf("(7)");
                    selectionRect.origin.x = ceil((float)hilStart * (float)reductionFactor);

                    selectionRect.size.width = (float)reductionFactor * (float)(hilEnd + 1);
                    if ((int)selectionRect.size.width == ceil(selectionRect.size.width))
                            selectionRect.size.width -= 1;
                    else selectionRect.size.width = (int)selectionRect.size.width;
                    selectionRect.size.width -= (ceil(reductionFactor * hilStart) - 1);

                }
                else {
				printf("(8)");
                    selectionRect.origin.x = ceil((float)NSMinX(adjSelRect) * (float)reductionFactor);
                    selectionRect.size.width = 0;
                }
                            /* now check to see if we need to adjust to original values.
                            * First, check to see if initial point has changed. If not, set
                            * original start, and adjust length. If so, discard 'original' point
                            */
    			printf("rs %d re %d ",realStart,realEnd);
                if ((realStart != -1) && hilStart == (int)(realStart / reductionFactor)) {
    				printf("(9)");
                    selectionRect.size.width = ceil((hilEnd + 1) * reductionFactor) - realStart;
                    selectionRect.origin.x = realStart;
                    }
                else realStart = -1;
                if ((realEnd != -1) && hilEnd == (int)(realEnd / reductionFactor)) {
				printf("(a)");
                        selectionRect.size.width = (int)(realEnd - NSMinX(selectionRect)) + 1;
                }
                else realEnd = -1;
                            /* Finally, adjust selection width down to sound size, if it ends on last pixel.
                            * When the num of pixels is not a direct multiple of redfact, the calculation
                            * for selectionRect, based on the last pixel highlighted, will come out with
                            * a figure slightly too high.
                            */
                if ((int)((float)NSMaxX(selectionRect) + 0.1) > NSMaxX([self bounds])) {
                        selectionRect.size.width = NSMaxX([self bounds]) - NSMinX(selectionRect);
                }
    			printf("selection changed to %g, width %g\n",NSMinX(selectionRect),NSWidth(selectionRect));
            }

    		printf("adjselrect start,end %g %g, dx %g, hs %d he %d oldx1 %g ", NSMinX(adjSelRect),NSMaxX(adjSelRect),dx,hilStart,hilEnd,oldx);

                            /* now show what we've done */
            [[self window] flushWindow];

                            /*
                            * if we autoscrolled, flush any lingering window server events to make
                            * the scrolling smooth
                            */
            if (scrolled) {
                //PSWait();
                scrolled = NO;
            }

                            /* save the current mouse location, just in case we need it again */
            oldx = mouseLocation.x + 1;
            if (!useTimerLocation) mouseLocation = [event locationInWindow];
            else mouseLocation = timerMouseLocation;

            if (![[self window] nextEventMatchingMask:MOVE_MASK untilDate:[NSDate date] inMode:NSEventTrackingRunLoopMode dequeue:NO]) {
                            /*
                            * no mouseMoved or mouseUp event immediately available, so take
                            * mouseMoved, mouseUp, or timer
                            */
                event = [[self window] nextEventMatchingMask:MOVE_MASK|NSPeriodicMask];
            } else {
                            /* get the mouseMoved or mouseUp event in the queue */
                event = [[self window] nextEventMatchingMask:MOVE_MASK];
            }

                            /* if a timer event, mouse location isn't valid, so we'll set it */
            if ([event type] == NSPeriodic) {
                timerMouseLocation = mouseLocation;
                useTimerLocation = YES;
            }
            else useTimerLocation = NO;
    }
    
  /* mouseUp, so stop any timer and unlock focus */
    stopTimer(timer);
    [self unlockFocus];

    if (NSWidth(selectionRect) < 0.1) {  /* if we weren't left with a selection,
                                          * stick insertion point in new place
                                          */
        selectionRect.origin.x = ceil(mouseDownLocation.x * (float)reductionFactor);
        selectionRect.size.width = 0;
    }
	printf("FINAL SELECTION %g, %g\n",NSMinX(selectionRect),NSWidth(selectionRect));

    [[self window] setAcceptsMouseMovedEvents:NO];
    if (reductionFactor < 1) [self setNeedsDisplay:YES]; /* to align to sample boundaries! */
    if (NSWidth(selectionRect) < 0.1)  [self showCursor];
}
- (BOOL)scrollPointToVisible:(const NSPoint)point
{
    NSRect r;

    r.origin = point;
    r.size.width = r.size.height = 0.1;

    return [self scrollRectToVisible:r];
}
- (void)toggleCursor
{
    NSRect cursorRect = [self bounds];
    cursorRect.origin.x = (int)((float)NSMinX(selectionRect) / (float)reductionFactor);
    cursorRect.size.width = 1;
    [self lockFocus];
    NSHighlightRect(cursorRect);
    [self unlockFocus];
    [[self window] flushWindow];
    svFlags.cursorOn = !svFlags.cursorOn;
}

- hideCursor
{
    if (teNum) {
            [teNum invalidate];
            [teNum release];
            teNum = NULL;
            if (svFlags.cursorOn) [self toggleCursor];
            svFlags.cursorOn = NO;
    }
    return self;
}
- showCursor
{
    if (!teNum) {
        if (NSWidth(selectionRect) < 0.1) {
            if (!svFlags.cursorOn) [self toggleCursor];

            teNum = [[NSTimer scheduledTimerWithTimeInterval:0.5
                                                      target:self
                                                    selector:@selector(toggleCursor)
                                                    userInfo:self
                                                     repeats:YES] retain];
        }
    }
    return self;
}

