#include "test.h"
#include "NSNonBlockingFileHandle.h"
@implementation TestMain
//GET / HTTP/1.0
-(id)init
{
  if ((self=[super init]))
    {
      _selfLock=[NSLock new];
    };
  return self;
};

-(void)lock
{
  NSLog(@"ThreadID=%p lock\n",(void*)objc_thread_id());
  [_selfLock lock];
  NSLog(@"ThreadID=%p locked\n",(void*)objc_thread_id());
};

-(void)unlock
{
  NSLog(@"ThreadID=%p unlock\n",(void*)objc_thread_id());
  [_selfLock unlock];
  NSLog(@"ThreadID=%p unlocked\n",(void*)objc_thread_id());
};

-(void)prepare
{
  NSAssert(!_fileHandle,@"fileHandle already exists");
  _fileHandle=[[NSFileHandle fileHandleAsServerAtAddress:[[NSHost currentHost] name]
			    service:[NSString stringWithFormat:@"%d",(int)THE_IN_PORT]
			    protocol:@"tcp"] retain];
  [[NSNotificationCenter defaultCenter] addObserver:self
					selector: @selector(announceNewConnection:)
					name: NSFileHandleConnectionAcceptedNotification
					object:_fileHandle];
  [_fileHandle acceptConnectionInBackgroundAndNotify];
  [NSThread detachNewThreadSelector:@selector(prepareTimer:)
            toTarget:self
            withObject:nil];
  NSLog(@"END Prepare: readInProgress=%d",(int)[_fileHandle readInProgress]);
};


//SetTimers
-(void)prepareTimer:(id)v
{
  NSAutoreleasePool* arp=[NSAutoreleasePool new];
  [NSTimer scheduledTimerWithTimeInterval:15
           target:self
           selector:@selector(handleTimer:)
           userInfo:nil
           repeats:YES];
  [NSRunLoop run];
  DESTROY(arp);
  [NSThread exit];
};

-(void)handleTimer:(id)timer
{
  NSLog(@"Timer Fired: Locking");
  [self lock];
  NSLog(@"Locked");
  {
    //Do some silly things
    NSDate* startDate=[NSDate date];
    NSDate* maxDate=[NSDate dateWithTimeIntervalSinceNow:10]; //10s
    int lastTI=0;
    do
      {
        usleep(1000);//1s
        if (((int)[[NSDate date]timeIntervalSinceDate:startDate])>=lastTI)
          {
            NSLog(@"ThreadID=%p - Timer Silly process",(void*)objc_thread_id());
            {
              NSURL* url=[[[NSURL alloc] initWithScheme:@"http"
                                         host:@"www.orange-concept.com"
                                         path:[NSString stringWithFormat:@"/cgi-bin/test.pl?param=%f",[[NSDate date]timeIntervalSince1970]]] autorelease];
              NSData* data = [url resourceDataUsingCache:NO];
              NSString* string=[[[NSString alloc]initWithData:data
                                                 encoding:NSISOLatin1StringEncoding]autorelease];
              NSLog(@"Data length=%d",[data length]);
              NSLog(@"String: %@",string);
            };
            lastTI+=2;
          };
      } while ([[NSDate date]compare:maxDate]!=NSOrderedDescending);
  };
  NSLog(@"Unlocking");
  [self unlock];
  NSLog(@"Unlocked");
};

-(id)announceNewConnection:(id)notification
{
  TestObject* testObject=nil;
  NSFileHandle* listenHandle=nil;
  NSFileHandle* inStream = nil;
  NSCalendarDate* requestDate=nil;
  listenHandle=[notification object];
  requestDate=[NSCalendarDate calendarDate];
  NSLog(@"REQUEST at %@: listenHandle=%p",requestDate,(void*)listenHandle);
  inStream = [[notification userInfo]objectForKey:@"NSFileHandleNotificationFileHandleItem"];
  NSLog(@"readInProgress=%d",(int)[_fileHandle readInProgress]);

  //release done after lock !
  testObject=[[TestObject alloc] initWithMain:self
                                 withStream:inStream];
  NSAssert(testObject,@"No test object create");
  NS_DURING
    {
      if (CONN_MT)
        {
          NSLog(@"Lauch Thread (Multi) %p",testObject);
          [NSThread detachNewThreadSelector:@selector(run:)
                    toTarget:testObject
                      withObject:nil];
        };
    }
  NS_HANDLER
    {
      NSLog(@"EXCEPTION %@ (%@)",
            localException,[localException reason]);
      [localException raise];
    }
  NS_ENDHANDLER;
  if (!CONN_MT)
    {
      NSLog(@"Launch Thread (Mono) %p",testObject);
      [testObject run:nil];
      DESTROY(testObject);
    };
  [listenHandle acceptConnectionInBackgroundAndNotify];
  NSLog(@"readInProgress=%d",(int)[_fileHandle readInProgress]);
  NSLog(@"END request");
  return self;
};

@end



@implementation TestObject

-(id)initWithMain:(TestMain*)mainObject
       withStream:(NSFileHandle*)stream
{
  if ((self=[self init]))
    {
      ASSIGN(_mainObject,mainObject);
      ASSIGN(_inStream,stream);      
    };
  return self;
};

-(void)dealloc
{
  NSLog(@"dealloc TestObject %p",self);
  DESTROY(_mainObject);
  DESTROY(_inStream);
  DESTROY(_pool);
  [super dealloc];
};

//--------------------------------------------------------------------
-(NSMutableArray*)completeLinesWithData:(NSMutableData*)data_
                  returnedConsumedCount:(int*)consumedCount_
                 returnedHeadersEndFlag:(BOOL*)headersEndFlag_
{
  NSMutableArray* _lines=nil;
  int _length=0;
  _length=[data_ length];
  if (_length>0)
    {
      NSRange _range=NSMakeRange(0,0);
      int i=0;
      char* _dataBytes=(char*)[data_ mutableBytes];
      BOOL _endHeaders=NO;
      while(!_endHeaders && i<_length)
        {
          if (_dataBytes[i]=='\n')
            {
              if (_range.length>0)
                {
                  NSString* tmpString=[[[NSString alloc]initWithData:[data_ subdataWithRange:_range]
                                                        encoding:NSASCIIStringEncoding]autorelease];
                  if (!_lines)
                    _lines=[NSMutableArray array];
                  [_lines addObject:tmpString];
                }
              else // End Header
                {
                  _endHeaders=YES;
                };
              _range.location=i+1;
              _range.length=0;
            }
          else
            _range.length++;
          i++;
        };
      _range.length=_length-_range.location;
      if (_range.length>0)
        memcpy(_dataBytes,_dataBytes+_range.location,_range.length);
      [data_ setLength:_range.length];
      if (consumedCount_)
        *consumedCount_=_length-_range.length;
      if (headersEndFlag_)
        *headersEndFlag_=_endHeaders;
    };
  return _lines;
};

//--------------------------------------------------------------------
-(BOOL)readRequestReturnedRequestLine:(NSString**)requestLine_
                      returnedHeaders:(NSDictionary**)headers_
                         returnedData:(NSData**)data_
{
  BOOL ok=NO;
  NSAssert(_inStream,@"No Stream");
  {
#define REQUEST_METHOD__UNKNOWN	0
#define REQUEST_METHOD__GET	1
#define REQUEST_METHOD__POST	2
    NSMutableData* _pendingData=nil;
    NSDate* maxDate=[NSDate dateWithTimeIntervalSinceNow:360]; //360s
    NSData* dataBlock=nil;
    int sleepTime=250; //250ms
    int readenBytesNb=0;
    int headersBytesNb=0;
    int dataBytesNb=0;
    int dataBlockLength=0;
    int contentLength=-1;
    int _requestMethod=REQUEST_METHOD__UNKNOWN;
    BOOL _isRequestLineSetted=NO;
    BOOL _isDataStep=NO;
    BOOL _isAllDataReaden=NO;
    BOOL _isElapsed=NO;
    NSMutableDictionary* _headers=nil;
    do
      {
        dataBlock=[_inStream availableDataNonBlocking];
        dataBlockLength=[dataBlock length];
        if (dataBlockLength>0)
          {
            readenBytesNb+=dataBlockLength;
            if (!_pendingData)
              _pendingData=(NSMutableData*)[NSMutableData data];
            [_pendingData appendData:dataBlock];
            if (_isDataStep)
              dataBytesNb=[_pendingData length];
            else
              {
                int _newBytesCount=0;
                NSMutableArray* _newLines=[self completeLinesWithData:_pendingData
                                                returnedConsumedCount:&_newBytesCount
                                                returnedHeadersEndFlag:&_isDataStep];
                headersBytesNb+=_newBytesCount;
                if (_newLines)
                  {                    
                    int i=0;
                    for(i=0;i<[_newLines count] && !_isAllDataReaden;i++)
                      {
                        NSString* _line=[_newLines objectAtIndex:i];
                        //NSLog(@"Line l=%d #%@#",[_line length],_line);
                        NSAssert([_line length]>0,@"No line length");
                        if ([_line length]==1)
                          _isAllDataReaden=YES;
                      };
                  };
              };
          };
        dataBytesNb=[_pendingData length];
        if (!_isAllDataReaden)
          {
            _isElapsed=[[NSDate date]compare:maxDate]==NSOrderedDescending;
            if (!_isElapsed)
              {
                usleep(sleepTime);//Is this the good method ? //TODOV
                _isElapsed=[[NSDate date]compare:maxDate]==NSOrderedDescending;
              };
          };
      } while (!_isAllDataReaden && !_isElapsed);
    ok=_isAllDataReaden;
    if (_isAllDataReaden)
      {
        *headers_=[[_headers copy] autorelease];
        if ([_pendingData length]>0)
          *data_=[_pendingData copy];
        else
          *data_=nil;			
      }
    else
      {
        *requestLine_=nil;
        *headers_=nil;
        *data_=nil;
      };
  };
  return ok;
};

//--------------------------------------------------------------------
-(void)run:(id)v
{
  BOOL requestOk=NO;
  NSString* requestLine=nil;
  NSDictionary* headers=nil;
  NSData* data=nil;
  _pool=[NSAutoreleasePool new];
/*  if (isMultiThread)
    {
      [[NSNotificationCenter defaultCenter] addObserver:[self class]
                                            selector:@selector(threadExited:)
                                            name:NSThreadExiting//NSThreadWillExitNotification
                                            object:[NSThread currentThread]];
    };
*/
  NS_DURING
    {
      requestOk=[self readRequestReturnedRequestLine:&requestLine
                      returnedHeaders:&headers
                      returnedData:&data];
    }
  NS_HANDLER
    {
      NSLog(@"EXCEPTION %@ %@",localException,[localException reason]);
      [localException raise];
    }
  NS_ENDHANDLER;
  if (requestOk)
    {
      NS_DURING
        {
          NSData* responseData=nil;
          NSString* response=nil;;
//Date: Sun, 29 Apr 2001 11:29:39 GMT

          NSLog(@"Locking");
          [_mainObject lock];
          NSLog(@"Locked");
          {
            //Do some silly things
            NSDate* startDate=[NSDate date];
            NSDate* maxDate=[NSDate dateWithTimeIntervalSinceNow:20]; //10s
            int lastTI=0;
            [NSTimeZone timeZoneWithName:@"EST"];
            do
              {
                usleep(1000);//1s
                if (((int)[[NSDate date]timeIntervalSinceDate:startDate])>=lastTI)
                  {
                    NSLog(@"ThreadID=%p - Connection Silly process",(void*)objc_thread_id());
                    lastTI+=2;
                  };
              } while ([[NSDate date]compare:maxDate]!=NSOrderedDescending);
          };
          NSLog(@"Unlocking");
          [_mainObject unlock];
          NSLog(@"Unlocked");
          response=[NSString stringWithFormat:@"HTTP/1.1 200 OK\n
Server: TEST
Connection: close
Content-Type: text/html

<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">
<html>
<head>
%@
</body>
</html>\n",[NSDate date]];
          responseData=[response dataUsingEncoding:NSISOLatin1StringEncoding];
          [_inStream writeData:responseData];
	  [_inStream closeFile];
        }
      NS_HANDLER
        {
          NSLog(@"EXCEPTION %@ %@",localException,[localException reason]);
          [localException raise];
        }
      NS_ENDHANDLER;
    };
  if (CONN_MT)
    {
      NSAssert([NSThread isMultiThreaded],@"No MultiThread !");
      [NSThread exit]; //???
    };
};

@end

