#import <Foundation/Foundation.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#define TISIC  1000

void printHelp (char *name)
{
    printf ("    Utility for test '-stringWithFormat:' metode (class NSString).\n");
    printf ("!!! Run this utility and see size of used memory (for example with 'top') !!!\n");
    printf ("!!!        If size<=8193 is OK but if size>8193 is problem !!!\n");
    printf ("Use: \"%s [-h] [size [cykl]]\"\n", name);
    printf ("   -h   .. show this help\n");
    printf ("   size .. size of string [B] (default == 1024)\n");
    printf ("   cykl .. count of cyklus (default == 10)\n");
}  


int main (int argc, char *argv[])
{
  int               i, j, tmp, size=1024, cykl=10;
  time_t            t;
  NSMutableString   *s;
  id                pool = [NSAutoreleasePool new];

  // ---------- input arguments
  if (argc > 1)
  {
      i = 1;                // first argument
      if ((argc>i) && (atoi(argv[i])>0))                // size of string
      {
          size = atoi(argv[i]);
          i++;
      }
      if ((argc>i) && (atoi(argv[i])>0))                // count of cyklus
      {
          cykl = atoi(argv[i]);
          i++;
      }
      if (i==1)                                         // unknown parametr
      {
          printHelp (argv[0]);
          return (-1);
      }
  }

  // ---------- start
  printf ("==========================================\n");
  printf ("test    :  '-stringWithFormat:' size %d B (%d cykl.)\n", size, cykl);
  time (&t); printf ("start   :  %s", ctime(&t));
  // create string (2 Bytes is append later)
  s = [NSMutableString stringWithCapacity:size-2];
  for (i=0; i<(size-2); i++)
    [s appendString:@"x"];

  for (i=0; i<cykl; i++)
  {
      printf ("%7d :", i+1); fflush(stdout);
      tmp = 0;
      for (j=0; j<TISIC; j++)
      {
        id  subPool = [NSAutoreleasePool new];
        // *********************************************************
        //             THIS IS CRITICAL METODE
        NSString *s1 = [NSString stringWithFormat:@"(%@)", s];
        // *********************************************************
        tmp += [s1 length];
        [subPool release];
      }
      printf (" %d\n", tmp/TISIC);
  }
  
  // ---------- stop
  time (&t);
  printf ("stop    :  %s", ctime(&t));
  printf ("==========================================\n");

  [pool release];
  return (0);
}
