/*
    
    GSInputServerImpl.m

    Author: Kazunobu Kuriyama <kazunobu.kuriyama@nifty.com>
    Date:   July, 2003

 */

#include <AppKit/NSInputManager.h>
#include "GSInputServerImpl.h"

@class GSInputServer;

// ----------------------------------------------------------------------------
//  GSInputServer
// ----------------------------------------------------------------------------
static GSInputServer   *server = nil;


@implementation GSInputServer

+ (id) sharedInstance
{
  if (server == nil)
    {
      server = [[GSInputServer alloc] init];
    }
  return server;
}

- (id) init
{
  [super init];

  return self;
}

/*
 *  NSInputServiceProvider Protocol Methods
 */
- (void) activeConversationChanged: (id)sender
                 toNewConversation: (long)newConversation
{
}

- (void) activeConversationWillChange: (id)sender
                  fromOldConversation: (long)oldConversation
{
}

- (BOOL) canBeDisabled
{
    return NO;
}

- (void) doCommandBySelector: (SEL)aSelector
                      client: (id)sender
{
  [sender doCommandBySelector: aSelector];
}

- (void) inputClientBecomeActive: (id)sender
{
}

- (void) inputClientDisabled: (id)sender
{
}

- (void) inputClientEnabled: (id)sender
{
}

- (void) inputClientResignActive: (id)sender
{
}

- (void) insertText: (id)aString
             client: (id)sender
{
  [sender insertText: aString];
}

- (void) markedTextAbandoned: (id)sender
{
}

- (void) markedTextSelectionChanged: (NSRange)newSelection
                             client: (id)sender
{
}

- (void) terminate: (id)sender
{
}

- (BOOL) wantsToDelayTextChangeNotifications
{
  return NO;
}

- (BOOL) wantsToHandleMouseEvents
{
  return NO;
}

- (BOOL) wantsToInterpretAllKeystrokes
{
  return NO;
}

/*
 *  NSInputServerMouseTracker Protocol Methods
 */
- (BOOL) mouseDownOnCharacterIndex: (unsigned)index
                      atCoordinate: (NSPoint)point
                      withModifier: (unsigned int)flags
                            client: (id)sender
{
  return NO;
}

- (BOOL) mouseDraggedOnCharacterIndex: (unsigned)index
                         atCoordinate: (NSPoint)point
                         withModifier: (unsigned int)flags
                               client: (id)sender
{
  return NO;
}

- (void) mouseUpOnCharacterIndex: (unsigned)index
                    atCoordinate: (NSPoint)point
                    withModifier: (unsigned int)flags
                          client: (id)sender
{
  // Do nothing.
}

@end  // @implementation GSInputServer
