/*
	NSFileManager+directories.h
	Mon Dec  9 11:30:36 CET 2002
	stefan.boehringer@uni-essen.de

	
 */

#import	<Foundation/Foundation.h>

@interface NSFileManager(NSFileManagerDirectories)

- (NSData *)dataRepresentationAtPath:(NSString *)somePath;
- (void)writeDataRepresentation:(NSData *)data toPath:(NSString *)somePath;

- (BOOL)createAllDirectoriesComposingPath:(NSString *)path attributes:(NSDictionary *)attributes;

@end

@interface NSFileManager(NSTemoraryFilesManagement)

- (NSString *)temporaryPathWithPrefix:(NSString *)prefix;
- (NSString *)temporaryPathWithPrefix:(NSString *)prefix andPostfix:(NSString *)postfix;

- (NSString *)temporaryPathInTempPathWithPrefix:(NSString *)prefix;
- (NSString *)temporaryPathInTempPathWithPrefix:(NSString *)prefix andPostfix:(NSString *)postfix;

@end

@interface NSString(NSPathManipulationExtensions)
- (NSString *)stringByAppendingPathComponents:(NSString *)component1, ...;
@end
