/*
	NSProcessInfo+getopt.h
	Tue Dec 10 11:27:37 CET 2002

 */

#import	<Foundation/Foundation.h>

#define	argYES	[NSNumber numberWithInt:1]
#define	argNO	[NSNumber numberWithInt:0]


@interface NSProcessInfo(Getopt)

/*
  option specifictations are as follows:
	option[=T]
  when the '=T' part is optional. With a name alone the option is a switch.
  T is a type being either i or s, representing integers or strings.

  To specify an argument the option is written as either:
	--option optionArgument
	--option=optionArgument
  Switches can be written as either:
	--option
	--option=YES
	--option=NO

  See also the perl documentation for Getopt::Long which is mimicked here in a loose manner.
  Different options are taken as a string each. A dictionary containing the values for given options
  is returned. An NSNumber being either 0 or 1 is returned for switches.
 */

- (NSDictionary *)getOptionsFromSpecification:(NSArray *)optionsSpecification;
- (NSDictionary *)getOptionsFromSpecification:(NSArray *)optionsSpecification
	defaults:(NSDictionary *)defaults;
- (NSDictionary *)getOptionsFromSpecification:(NSArray *)optionsSpecification
	defaults:(NSDictionary *)defaults remainingArguments:(NSArray **)remainingArguments;

@end
