/*
	ZillionClient.h
	Mon Dec  9 16:14:54 CET 2002
 */

#import	<Foundation/Foundation.h>
#import	"ZillionClientServer.h"

#define	ZILLION_CLIENT_NAME	@"zillionClient"

@protocol ZillionClientProtocol <NSObject>

- initWithRespawnStatus:(BOOL)respawnStatus andMasterServer:(id <ZillionServerProtocol>)masterServer;
- (id <ZillionClientProtocol>)masterClient;
- (void)setMasterClient:(id <ZillionClientProtocol>)masterClient;

- (NSDictionary *)attributes;
- (NSString *)clientId;
// the number of Jobs executed currently
- (int)currentLoad;
- (void)decreaseLoad;
- (void)increaseLoad;

/*
	someJob is a bundle collected to a data object
	a process is to be forked to separate the objc namespaces
	since unloading of classes is not supported as yet
 */
- (void)forkThreadForJobId:(NSString *)jobId withSeed:seed;
- (void)dispatchUnitFromSeed:(NSData *)seed forJobId:(NSString *)jobId;
- (void)stopUnitsForJobId:(NSString *)jobId;
- (void)submitOutcome:(NSData *)outcome ofJob:(NSString *)jobId forSeed:seed
	storeHints:(NSDictionary *)someStoreHint;
- (void)jobUnitDidEndForJobId:(NSString *)jobId seed:seed;

- (oneway void)terminate;

@end

@protocol ZillionServerProtocol;

@interface ZillionClient : ZillionClientServer <ZillionClientProtocol>
{
	BOOL	_clientToGoDown;
	BOOL	_respawnStatus;

	NSLock	*clientAdminLock;
	NSMutableDictionary	*jobClientDictionary;
	NSMutableDictionary	*threads;	
	NSDictionary		*_attributes;
	int		load;

	id <ZillionClientProtocol>	_masterClient;
}

- (BOOL)clientToGoDown;

@end
