/*
	ZillionClientServer.h
	Wed Dec 11 17:45:24 CET 2002
	copyright: Stefan Bhringer (stefan.boehringer@uni-essen.de) (2002, 2003)
	This code is governed by a BSD license as expounded in the LICENSE file
 */


#import	<Foundation/Foundation.h>
#import	<ZillionProtocols.h>

/*
	this class is to factor out code needed, both, by
	the classes ZillionServer and ZillionClient
 */

#define SETJOBA(jobSpec, v, attribute)	[jobSpec setObject:v forKey:attribute]
#define JOBA(jobSpec, attribute)		[jobSpec objectForKey:attribute]
#define	JOBBUNDLE(jobSpec)				JOBA(jobSpec, @"bundle")
#define	SETJOBBUNDLE(jobSpec, bundle)	SETJOBA(jobSpec, bundle, @"bundle")

@protocol ZillionServerProtocol;
@protocol ZillionJobProtocol;

@interface ZillionClientServer : NSObject <ZillionJobHandler>
{
	int						bundleSeq;
	id <ZillionServerProtocol>	_masterServer;
	NSMutableDictionary			*_jobs;			//store the jobs involved
}

// abstract
- (NSString *)DOname;

// abstract
- (NSArray *)respawningArgumentsWithId:(NSString *)doNameId;

// abstract
- (Protocol *)respawningProtocol;

// concrete
- (NSString *)respawningDOnameWithId:(NSString *)doNameId;

// concrete
- respawnedObject;
- respawnedObjectWithId:(NSString *)doNameId;
- respawnedObjectWithId:(NSString *)doNameId doObserveConnection:(BOOL)doObserve;


/*
	methods concerned with job creation
 */

- (NSBundle *)bundleForPackedBundle:(NSData *)packedBundle;

// creates an empty specification if needed
- (NSMutableDictionary *)jobSpecificationForJobId:(NSString *)jobId;
- (void)setJobSpecification:(NSDictionary *)jobSpec forId:(NSString *)joId;
- (NSArray *)jobIds;

- (id <ZillionJobProtocol>)instantiateJobFromBundle:(NSBundle *)jobBundle
	withResources:(NSData *)resources;
- (id <ZillionJobProtocol>)instantiateJobWithId:(NSString *)jobId;
- (Class)jobClassForJobId:(NSString *)jobId;

/*
	common administrative methods
 */
- (void)setMasterServer:(id <ZillionServerProtocol>)masterServer;
- (id <ZillionServerProtocol>)masterServer;

/*
	default server scratch directory
	tb overwritten by subclasses
 */
- (NSString *)serverTemporaryPath;
- (NSString *)outcomeDirectory;

@end
