/*
	ZillionProtocols.h
	Mon Jun 30 16:09:32 MEST 2003
 */

#import	<Foundation/Foundation.h>

@protocol ZillionJobProtocol;

@protocol ZillionJobHandler <NSObject>

/*
	provide a job with vital information
 */

- (NSString *)temporaryDirectory;
- (NSString *)outcomeDirectoryForJobId:(NSString *)jobId;

/*
	depending on the nature of the jobHandler several things may happen
	a client will forward results to the server
	the server will forward results to a central instance of the job 
 */
- (void)submitOutcome:(NSData *)outcome ofJob:(NSString *)jobId forSeedId:(NSData *)seedId
	storeHints:(NSDictionary *)someStoreHint;
- (void)submitOutcome:(NSData *)outcome ofJob:(NSString *)jobId forSeed:seed
	storeHints:(NSDictionary *)someStoreHint;

- (void)jobUnitDidEndForJobId:(NSString *)jobId seed:seed;

- (NSDictionary *)outcomeDictionaryForJobId:(NSString *)jobId;

- (id <ZillionJobProtocol>)jobInstance:(NSString *)jobId;

@end

@protocol ZillionJobProtocol <NSObject>

- initWithBundle:(NSBundle *)someBundle
	resources:(NSData *)resources
	jobHandler:(id <ZillionJobHandler>)jobHandler;

- (NSString *)jobId;
- (BOOL)storesOutcomesInMemory;
- (NSData *)dataRepresentationOfSeed:seed;
- seedObjectFromDataRepresentation:(NSData *)seed;

- (NSEnumerator *)seedEnumeratorWithSeed:(NSData *)seed;

/*
	The specification of the jobs entails the following keys (with ovious meanings)
	ZillionClientKey
	ZillionSeedKey
 */

- (void)startJobUnitWithSeed:aSeed;

/*
	The job class must not store any information in global variables since the class
	may be deallocated at any time. Instead the information can be stored in the server
	via -setOutcome:forSeedId:andJobId:
	on account of job supension/reactivation
	<i> to be changed
 */

- (void)sealJobOutcomes;

@end

/*
	This protocol is to be implemented if individual outcomes are to be processed
	in the course of job execution
 */

@protocol ZillionJobOutcomeProcessing
- (void)saveOutcome:(NSData *)outcome forSeedId:(NSData *)seedId
	storeHints:(NSDictionary *)someStoreHint;
@end

@protocol ZillionSeed
- (NSString *)description;
@end
