/*
	ZillionServer.h
	Tue Aug 27 17:00:11 CEST 2002
 */

#import <Foundation/Foundation.h>
#import	"ZillionProtocols.h"
#import	"ZillionClientServer.h"
#import "ZillionClient.h"

#define	ZILLION_SERVER_NAME	@"zillion"

@protocol ZillionClientProtocol;
@protocol ZillionServerProtocol;
@protocol ZillionJobProtocol;

/*
	JobSpecification keys
 */
#define JOB_RESOURCES_KEY	@"resources"

@protocol ZillionServerProtocol <NSObject, ZillionJobHandler>

/*
	managing masters
 */
- (void)setMasterServer:(id <ZillionServerProtocol>)masterServer;
- (id <ZillionServerProtocol>)masterServer;
- (oneway void)terminate;

/*
	managing clients
 */
- (void)registerClient:(id <ZillionClientProtocol>)someClient;
- (void)deregisterClient:(id <ZillionClientProtocol>)someClient;


/*
	managing jobs
 */

/*
	this is the master method for the public server
	proxyServers are accessed through loadAndRegister
 */
- (NSString *)dispatchJob:(bycopy NSData *)bundle withResources:(NSData *)resources;
- (NSString *)dispatchJob:(bycopy NSData *)bundle;
- (bycopy NSString *)loadAndRegisterJob:(NSData *)bundle withResources:(NSData *)resources;
- (bycopy NSString *)loadAndRegisterJob:(NSData *)bundle;

- (void)registerJob:(NSData *)jobBundle
	withId:(NSString *)jobId
	resources:(NSData *)resources
	instance:(id <ZillionJobProtocol>)jobInstance;
- (NSMutableDictionary *)jobSpecificationForJobId:(NSString *)jobId;

- (NSData *)packedJobBundleForJobId:(NSString *)jobId;

- (void)jobUnitDidEndForJobId:(NSString *)jobId seedId:(NSData *)seedId
	timePenalty:(NSTimeInterval)penalty;

- (void)terminateJobWithId:(NSString *)jobId;
- (void)suspendJobWithId:(NSString *)jobId;
- (void)resumeJobWithId:(NSString *)jobId;

/*
	bringing the jobs into action
 */

// sender is a dummy argument to make it amenable to performSelector:
- (void)scheduleJobs:sender;
- (NSData *)nextSeedIdForJobId:(NSString *)jobId;

/*
	storing results
 */
- (void)setOutcome:(bycopy NSData *)outcome forSeedId:(bycopy NSData *)seedId
	andJobId:(bycopy NSString *)jobId;
- (NSMutableDictionary *)outcomeDictionaryForJobId:(bycopy NSString *)jobId;
- (void)setOutcomeDictionary:(NSMutableDictionary *)outcomes forJobId:(bycopy NSString *)jobId;

- (void)sealJobWithId:(NSString *)jobId;


/*
	avoid warning and crash
 */
- (void)setProtocolForProxy:(Protocol *)aProtocol;

@end

#define	ZillionClientKey	@"client"
#define	ZillionSeedKey		@"seed"
#define	ZillionJobKey		@"job"

@interface ZillionServer : ZillionClientServer <ZillionServerProtocol> 
{

	NSMutableDictionary	*proxyServers;
	unsigned			proxyServerIdCounter;

	NSMutableDictionary	*clients;

	BOOL	_serverToGoDown;
	BOOL	_respawnStatus;
	BOOL	_reschedulingIsMarked;

	NSString	*outcomeDirectory;
}

- initWithRespawnStatus:(BOOL)respawnStatus;
- (BOOL)serverToGoDown;

- (id <ZillionJobProtocol>)jobInstance:(NSString *)jobId;

@end
