/*
	zillionClient.m
	Mon Dec  9 16:13:27 CET 2002
 */

#import	"ZillionClient.h"
#import	"ZillionServer.h"
#import	"NSProcessInfo+getopt.h"


#define	CONNECTION_RETRIES	10
#define	SLEEP_INTERVAL		60

int main(int argc, const char **argv)
{
	NSAutoreleasePool	*mainPool = [[NSAutoreleasePool alloc] init];

	NSConnection		*theConnection;
	id					server;
	ZillionClient		*client;
	NSDate				*distantFuture = [NSDate distantFuture];
	NSRunLoop			*currentRunLoop = [NSRunLoop currentRunLoop];
	NSProcessInfo		*proc = [NSProcessInfo processInfo];
	NSDictionary		*options = [proc getOptionsFromSpecification:
		[NSArray arrayWithObjects:@"DOname=s", @"serverHostName", @"doRespawn", @"terminate", nil]
		defaults:[NSDictionary dictionaryWithObjectsAndKeys:
			argYES, @"doRespawn",
			@"*", @"serverHostName",
		nil]
		];
	BOOL				doRespawn = [[options objectForKey:@"doRespawn"] intValue];
	NSString			*DOname = [options objectForKey:@"DOname"];
	NSString			*serverName = [options objectForKey:@"serverHostName"];
	NSString			*name2register = DOname? DOname: ZILLION_CLIENT_NAME;
	int					i;

	if ([options objectForKey:@"terminate"]) {
		NSLog(@"Shutting down Zillion client");

		client = [[NSConnection rootProxyForConnectionWithRegisteredName:ZILLION_CLIENT_NAME
			host:nil] retain];
		if (!client)
			NSLog(@"No zillion client is running");
		else
			[client terminate];

		[mainPool release];
		return 0;
	}

	NSLog(@"Starting client [respawning:%@]...", doRespawn? @"YES": @"NO");
	client = [[ZillionClient alloc] initWithRespawnStatus:doRespawn andMasterServer:server];

	// if DOname is set we register with that name to await
	// contacts from outside
	// otherwise we choose a standard name to allow for other interactions also
	NSLog(@"Registering proxy client with DO name: %@", name2register);
	theConnection = [NSConnection defaultConnection];
	[theConnection setRootObject:client];
	if ([theConnection registerName:name2register] == NO) {
		NSLog(@"Could not register name with PortName server");
	}

	for (i = 0; i < CONNECTION_RETRIES; i++) {
		if (i) {
			NSDate	*waitUntil = [NSDate dateWithTimeIntervalSinceNow:SLEEP_INTERVAL];
			NSLog(@"Retrying to connect to server [%@]...", serverName);
			do {
				[currentRunLoop acceptInputForMode:NSDefaultRunLoopMode beforeDate:waitUntil];
			} while ([waitUntil compare:[NSDate date]] == NSOrderedDescending
				&& ![client clientToGoDown]);
		}
		if ([client clientToGoDown]) break;
		server = [[NSConnection rootProxyForConnectionWithRegisteredName:ZILLION_SERVER_NAME
			host:serverName] retain];
		if (server) break;
		NSLog(@"Couldn't connect to server...");
	}
	if (!server) {
		NSLog(@"Failed to establish connection after %d retries. Exiting.", CONNECTION_RETRIES);
		[client release];
		[mainPool release];
		return 1;
	} else
		[server setProtocolForProxy:@protocol(ZillionServerProtocol)];

	if (! DOname)	{
		[server registerClient:client];
		NSLog(@"registered client...");
	}

	while (![client clientToGoDown])
	{
		[currentRunLoop acceptInputForMode:NSDefaultRunLoopMode beforeDate:distantFuture];
	}

	NSLog(@"going down on client...");
	[server deregisterClient:client];
	[client release];
	[server release];

	[mainPool release];
	return 0;
}
