/*
	zillionLoader.m
	Mon Dec  9 18:35:36 CET 2002
 */

#import	"ZillionClient.h"
#import	"ZillionServer.h"
#import	"NSFileManager+directories.h"
#import	"NSProcessInfo+getopt.h"

void	loadJob(id <ZillionServerProtocol> server, NSString *pathToJob)
{
	NSProcessInfo		*pInfo = [NSProcessInfo processInfo];

}

int main(int argc, const char **argv)
{
	NSAutoreleasePool	*mainPool = [[NSAutoreleasePool alloc] init];
	id					server;
	NSProcessInfo		*pInfo = [NSProcessInfo processInfo];
	NSDictionary		*options = [pInfo getOptionsFromSpecification:[NSArray arrayWithObjects:
		@"suspendJob=s", nil] defaults:nil];

	NSLog(@"Loading job into Zillion...");
	server = [[NSConnection rootProxyForConnectionWithRegisteredName:ZILLION_SERVER_NAME
		host:nil] retain];
	[server setProtocolForProxy:@protocol(ZillionServerProtocol)];

	if ([[pInfo arguments] count] < 2) {
		NSLog(@"USAGE: %@ bundlePath1 [bundlePath2]+", [pInfo processName]);
	} else {
		int	i, count;
		NSFileManager	*fileManager = [NSFileManager defaultManager];
		NSData	*bundle;

		for (i = 1, count = [[pInfo arguments] count]; i < count; i++) {
			NSString *thisJob = [[pInfo arguments] objectAtIndex:i];
			NSLog(@"...identified %@", thisJob);
			NSLog(@"loading...");
			bundle = [fileManager dataRepresentationAtPath:thisJob];
			NSLog(@"dispatching...");
			[server dispatchJob:bundle];
			NSLog(@"..now %@ is running.", thisJob);
		}
	}


	[server release];
	[mainPool release];
	return 0;
}

// [NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:2]];
