#!/bin/csh
#
#   ld_fw_path.csh
#
#   Set up the LD_FRAMEWORK_PATH (or similar env variable for your system)
#
#   Copyright (C) 2004 Free Software Foundation, Inc.
#
#   Author:  David Ayers <d.ayers@inode.at>
#   Based on ld_lib_path.csh
#
#   This file is part of the GNUstep Makefile Package.
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
#   
#   You should have received a copy of the GNU General Public
#   License along with this library; see the file COPYING.LIB.
#   If not, write to the Free Software Foundation,
#   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

# The first (and only) parameter to this script is the canonical
# operating system name.

set last_path_part="Library/Frameworks"

set host_os=${GNUSTEP_HOST_OS}

if ( "${host_os}" == "" ) then
  set host_os=${1}
endif

set fw_paths="${GNUSTEP_USER_ROOT}/${last_path_part}:${GNUSTEP_LOCAL_ROOT}/${last_path_part}:${GNUSTEP_NETWORK_ROOT}/${last_path_part}:${GNUSTEP_SYSTEM_ROOT}/${last_path_part}"

switch ( "${host_os}" )

  case *nextstep4* :
    if ( $?DYLD_FRAMEWORK_PATH == 0 ) then
	setenv DYLD_FRAMEWORK_PATH "${fw_paths}"
    else if ( { (echo "${DYLD_FRAMEWORK_PATH}" | fgrep -v "${fw_paths}" >/dev/null) } ) then
	setenv DYLD_FRAMEWORK_PATH "${fw_paths}:${DYLD_FRAMEWORK_PATH}"
    endif
    if ( $?additional_fw_paths == 1) then
      foreach dir (${additional_fw_paths})
	set additional="${additional}${dir}:"
      end
    endif

    if ( "${?additional}" == "1" ) then
      if ( { (echo "${DYLD_FRAMEWORK_PATH}" | fgrep -v "${additional}" >/dev/null) } ) then
       setenv DYLD_FRAMEWORK_PATH="${additional}${DYLD_FRAMEWORK_PATH}"
      endif
    endif
    breaksw

  case *darwin* :
    if ( $?DYLD_FRAMEWORK_PATH == 0 ) then
	setenv DYLD_FRAMEWORK_PATH "${fw_paths}"
    else if ( { (echo "${DYLD_FRAMEWORK_PATH}" | fgrep -v "${fw_paths}" >/dev/null) } ) then
	setenv DYLD_FRAMEWORK_PATH "${fw_paths}:${DYLD_FRAMEWORK_PATH}"
    endif
    if ( $?additional_fw_paths == 1) then
      foreach dir (${additional_fw_paths})
	set additional="${additional}${dir}:"
      end
    endif

    if ( "${?additional}" == "1" ) then
      if ( { (echo "${DYLD_FRAMEWORK_PATH}" | fgrep -v "${additional}" >/dev/null) } ) then
       setenv DYLD_FRAMEWORK_PATH="${additional}${DYLD_FRAMEWORK_PATH}"
      endif
    endif
    breaksw

# This isn't useful until other platforms have linkers 
# which support frameworks, but we'll keep it here as a placeholder.
  case * :
    if ( $?LD_FRAMEWORK_PATH == 0 ) then
	setenv LD_FRAMEWORK_PATH "${fw_paths}"
    else if ( { (echo "${LD_FRAMEWORK_PATH}" | fgrep -v "${fw_paths}" >/dev/null) } ) then
	setenv LD_FRAMEWORK_PATH "${fw_paths}:${LD_FRAMEWORK_PATH}"
    endif
    if ( $?additional_fw_paths == 1) then
      foreach dir (${additional_fw_paths})
	set additional="${additional}${dir}:"
      end
    endif

    if ( "${?additional}" == "1" ) then
      if ( { (echo "${LD_FRAMEWORK_PATH}" | fgrep -v "${additional}" >/dev/null) } ) then
       setenv LD_FRAMEWORK_PATH="${additional}${LD_FRAMEWORK_PATH}"
      endif
    endif
    breaksw

endsw

unset tool_path_part last_path_part host_os additional dir fw_paths

