#! /bin/sh
#
#   ld_fw_path.sh
#
#   Set up the LD_LIBRARY_PATH (or similar env variable for your system)
#
#   Copyright (C) 2004 Free Software Foundation, Inc.
#
#   Author:  David Ayers <d.ayers@inode.at>
#   Based on ld_lib_path.sh
#
#   This file is part of the GNUstep Makefile Package.
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
#   
#   You should have received a copy of the GNU General Public
#   License along with this library; see the file COPYING.LIB.
#   If not, write to the Free Software Foundation,
#   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

# This file is sourced.  This means extra care is needed when changing
# it.  Please read the comments on GNUstep.sh.in before touching it.

# The first (and only) parameter to this script is the canonical
# operating system name.

host_os=$GNUSTEP_HOST_OS

if [ -z "$host_os" ]; then
  host_os=$1
fi


old_IFS="$IFS"
IFS=:
fw_paths=
for dir in $GNUSTEP_PATHLIST; do

  # prepare the path_fragment for this dir
  path_fragment="$dir/Library/Frameworks"

  # Append the path_fragment to fw_paths
  if [ -z "$fw_paths" ]; then
    fw_paths="$path_fragment"
  else
    fw_paths="$fw_paths:$path_fragment"
  fi

  unset path_fragment

done
IFS="$old_IFS"
unset old_IFS
unset dir


if [ -n "$additional_framework_paths" ]; then
  old_IFS="$IFS"
  IFS=" 
"
  additional=""
  for dir in $additional_framework_paths; do
    additional="${additional}${dir}:"
  done
  unset dir

  fw_paths="${additional}${fw_paths}"

  unset additional
  IFS="$old_IFS"
  unset old_IFS
fi

case "$host_os" in

  *nextstep4*)
    if [ -z "$DYLD_FRAMEWORK_PATH" ]; then
      DYLD_FRAMEWORK_PATH="$fw_paths"
    else
      if ( echo ${DYLD_FRAMEWORK_PATH}|fgrep -v "${fw_paths}" >/dev/null ); then
	DYLD_FRAMEWORK_PATH="$fw_paths:$DYLD_FRAMEWORK_PATH"
      fi
    fi
    export DYLD_FRAMEWORK_PATH
    ;;

  *darwin*)
    if [ -z "$DYLD_FRAMEWORK_PATH" ]; then
      DYLD_FRAMEWORK_PATH="$fw_paths"
    else
      if ( echo ${DYLD_FRAMEWORK_PATH}|fgrep -v "${fw_paths}" >/dev/null ); then
	DYLD_FRAMEWORK_PATH="$fw_paths:$DYLD_FRAMEWORK_PATH"
      fi
    fi
    export DYLD_FRAMEWORK_PATH
    ;;

  *)
    if [ -z "$DYLD_FRAMEWORK_PATH" ]; then
      DYLD_FRAMEWORK_PATH="$fw_paths"
    else
      if ( echo ${DYLD_FRAMEWORK_PATH}| grep -v "${fw_paths}" >/dev/null ); then
	DYLD_FRAMEWORK_PATH="$fw_paths:$DYLD_FRAMEWORK_PATH"
      fi
    fi
    export DYLD_FRAMEWORK_PATH;;

esac

unset host_os
unset fw_paths

