#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

void logCellEntryType(NSCell *cell);

@interface Foo : NSObject <NSCopying>
{

}
- (id) copyWithZone:(NSZone *)zone;
@end

@implementation Foo
- (id) copyWithZone:(NSZone *)zone
{
  return [self retain];
}

- (NSString *)stringValue
{
  NSLog(@"called -stringValue");
  return @"foooooo";
}
@end

int main(int argc, const char *argv[])
{
  NSAutoreleasePool *pool = [NSAutoreleasePool new];
  NSCell *cell;
  NSNumber *num;
  NSAttributedString *attr;
  [NSApplication sharedApplication];
  num = [NSNumber numberWithFloat:55.0];
  cell = [[NSCell alloc] initTextCell:@"foo"];
  
  [cell setObjectValue:num];
  NSLog(@"-objectValue=%@ KindOf=%@ formatter=%@ hasValidObjectValue=%@",
  	[cell objectValue], [[[cell objectValue] class] description], 
	[cell formatter], [cell hasValidObjectValue] ? @"YES" :  @"NO");
  logCellEntryType(cell);
  
  [cell setObjectValue:[Foo new]];
  NSLog(@"-objectValue=%@ KindOf=%@ formatter=%@ hasValidObjectValue=%@",
  	[cell objectValue], [[[cell objectValue] class] description], 
	[cell formatter], [cell hasValidObjectValue] ? @"YES" :  @"NO");
  logCellEntryType(cell);
  
  [cell setFloatValue:23.5];
  NSLog(@"-objectValue=%@ KindOf=%@ formatter=%@ hasValidObjectValue=%@",
  	[cell objectValue], [[[cell objectValue] class] description], 
	[cell formatter], [cell hasValidObjectValue] ? @"YES" :  @"NO");
  logCellEntryType(cell);
  NSLog(@"%i %f %f", [cell intValue], [cell floatValue], [cell doubleValue]);
 
  [cell setObjectValue:[[[NSAttributedString alloc] initWithString:@"zxcv"] autorelease]];
  NSLog(@"-objectValue=%@ KindOf=%@ formatter=%@ hasValidObjectValue=%@",
  	[cell objectValue], [[[cell objectValue] class] description], 
	[cell formatter], [cell hasValidObjectValue] ? @"YES" :  @"NO");
  logCellEntryType(cell);
 
  [cell setObjectValue:nil];
  NSLog(@"-objectValue=%@ KindOf=%@ formatter=%@ hasValidObjectValue=%@",
  	[cell objectValue], [[[cell objectValue] class] description], 
	[cell formatter], [cell hasValidObjectValue] ? @"YES" :  @"NO");

  [pool release];
  exit(0);
  return 0;
}

void logCellEntryType(NSCell *cell)
{
  switch ([cell entryType])
    {
      case NSIntType:
      	NSLog(@"NSIntType");
	break;
      case NSPositiveIntType:
      	NSLog(@"NSPositiveIntType");
        break;
      case NSFloatType:
      	NSLog(@"NSFloatType");
        break;
      case NSPositiveFloatType:
      	NSLog(@"NSPositiveFloatType");
        break;
      case NSDoubleType:
      	NSLog(@"NSDoubleType");
        break;
      case NSPositiveDoubleType:
      	NSLog(@"NSPositiveDoubleType");
        break;
      case NSAnyType:
      	NSLog(@"NSAnyType");
        break;
    }
}
