/* 
   Project: TestApp

   Copyright (C) 2006 Free Software Foundation

   Author: Mark Tracy

   Created: 2006-10-15 07:57:07 +0000 by mark
   
   Application Controller

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
 
#ifndef _PCAPPPROJ_APPCONTROLLER_H
#define _PCAPPPROJ_APPCONTROLLER_H

#include <AppKit/AppKit.h>

@class MyView;

@interface AppController : NSWindowController
{
float alpha;
NSCompositingOperation op;

IBOutlet NSTextField * alphaField;
IBOutlet NSSlider * alphaSlider;
IBOutlet NSPopUpButton * opSelect;
IBOutlet MyView * myView;
IBOutlet NSImageView * imageView;
IBOutlet NSView * exportAs;
IBOutlet NSMatrix * exportSelector;

NSSavePanel * savePanel;
}

+ (void)initialize;

- (id)init;
- (void)dealloc;

- (void)awakeFromNib;

- (void)applicationDidFinishLaunching:(NSNotification *)aNotif;
- (BOOL)applicationShouldTerminate:(id)sender;
- (void)applicationWillTerminate:(NSNotification *)aNotif;
- (BOOL)application:(NSApplication *)application openFile:(NSString *)fileName;

- (void)showPrefPanel:(id)sender;

- (IBAction) changeAlpha: (id) sender;
- (IBAction) changeOp: (id) sender;

- (IBAction) saveView: (id) sender;
- (IBAction) saveImage: (id) sender;

- (float) alpha;
- (NSCompositingOperation) op;
- (NSString *) opName;

- (IBAction) changeExportFormat: (id) sender;

- (IBAction) loadImage: (id) sender;
- (void)openPanelDidEnd:(NSOpenPanel *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo;
@end

#endif
