/* 
   Project: TestApp

   Copyright (C) 2006 Free Software Foundation

   Author: Mark Tracy

   Created: 2006-10-15 07:57:07 +0000 by mark
   
   Application Controller

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "AppController.h"
#include "MyView.h"

@implementation AppController

+ (void)initialize
{
  NSMutableDictionary *defaults = [NSMutableDictionary dictionary];

  /*
   * Register your app's defaults here by adding objects to the
   * dictionary, eg
   *
   * [defaults setObject:anObject forKey:keyForThatObject];
   *
   */
  
  [[NSUserDefaults standardUserDefaults] registerDefaults:defaults];
  [[NSUserDefaults standardUserDefaults] synchronize];
}

- (id)init
{
  if ((self = [super init]))
    {
    }
  return self;
}

- (void)dealloc
{
  [super dealloc];
}

- (void)awakeFromNib
{
  [[NSApp mainMenu] setTitle:@"TestApp"];
    alpha = 1.0;
    [alphaField setFloatValue: alpha];
    [alphaSlider setFloatValue: alpha];
    NSArray * ops = [NSArray arrayWithObjects:
        @"Clear", @"Copy", @"SourceOver", @"SourceIn", @"SourceOut", @"SourceATop",
        @"DestinationOver", @"DestinationIn", @"DestinationOut", @"DestinationATop",
        @"XOR", @"PlusDarker", @"Highlight", @"PlusLighter", nil];
    op = NSCompositeCopy;
    [opSelect removeAllItems];
    [opSelect addItemsWithTitles: ops];
    [opSelect selectItemAtIndex: (unsigned int)op];
    [opSelect synchronizeTitleAndSelectedItem];

    [self showWindow: self];
  // just checking the available TIFF compressions
  int i, n;
  NSTIFFCompression * list;
  [NSBitmapImageRep getTIFFCompressionTypes: &list count: &n];
  NSLog(@"%i defined TIFF compression types", n);
  for (i = 0; i < n; i++)
  {
    NSLog(@"%i\t%@", [NSBitmapImageRep _localFromCompressionType: list[i]],
      [NSBitmapImageRep localizedNameForTIFFCompressionType: list[i]]);
  }
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotif
{
}

- (BOOL)applicationShouldTerminate:(id)sender
{
  return YES;
}

- (void)applicationWillTerminate:(NSNotification *)aNotif
{
}

- (BOOL)application:(NSApplication *)application openFile:(NSString *)fileName
{
  NSImage * anImage = [[[NSImage alloc] initWithContentsOfFile: fileName] autorelease];
  if ( anImage != nil )
  {
    [imageView setImage: anImage];
    return YES;
  }
  else
  {
    NSLog(@"Unable to load image file \"%@\"", fileName);
    return NO;
  }
}

- (void)showPrefPanel:(id)sender
{
}

- (IBAction) changeAlpha: (id) sender
{
    alpha = [alphaSlider floatValue];
    [alphaField setFloatValue: alpha];
    [myView setNeedsDisplay: YES];
}

- (IBAction) changeOp: (id) sender
{
    op = (NSCompositingOperation) [opSelect indexOfSelectedItem];
    [opSelect synchronizeTitleAndSelectedItem];
    [myView setNeedsDisplay: YES];
}

- (BOOL) shouldRunSavePanelWithAccessoryView { return YES; };

- (IBAction) saveView: (id) sender
{
	if (exportAs == nil) [NSBundle loadNibNamed: @"exportAs" owner: self];
    if (exportAs == nil) return;
    if (exportSelector == nil) return;

	savePanel = [NSSavePanel savePanel];
	[savePanel setAccessoryView: exportAs];
	[self changeExportFormat: exportSelector];
	[savePanel beginSheetForDirectory: nil
								 file: nil
					   modalForWindow: [self window]
						modalDelegate: self
					   didEndSelector: @selector(exportPanelDidEnd:returnCode:contextInfo:)
						  contextInfo: myView];
}

- (void) exportPanelDidEnd: (NSSavePanel *) sheet returnCode: (int) returnCode contextInfo: (void *) contextInfo
{
	if (returnCode == NSCancelButton) return;
    NSView * view = (NSView *) contextInfo;
	NSData * representation = nil;
	NSDictionary * options = nil;
    NSString * fileType = [savePanel requiredFileType];
    BOOL ok = NO;
	if ([fileType isEqualToString: @"pdf"])    //GNUstep support is missing
    {
//		representation = [view dataWithPDFInsideRect: [view bounds]];
		ok = (representation != nil);
	}
	if ([fileType isEqualToString: @"eps"])
	{
		representation = [view dataWithEPSInsideRect: [view bounds]];
		ok = (representation != nil);
	}
	if ([fileType isEqualToString: @"tif"])
	{
        [view lockFocus];
        NSBitmapImageRep * rep =
            [[NSBitmapImageRep alloc] initWithFocusedViewRect: [view bounds]];
        [view unlockFocus];
        [rep autorelease];
//        [rep setProperty: NSImageCompressionMethod withValue: [NSNumber numberWithUnsignedShort: NSTIFFCompressionLZW]];
        options = [NSDictionary dictionaryWithObjectsAndKeys:
          [NSNumber numberWithUnsignedShort: NSTIFFCompressionJPEG], NSImageCompressionMethod, 
          [NSNumber numberWithFloat: 255.0], NSImageCompressionFactor, nil];
        representation = [rep representationUsingType: NSTIFFFileType properties: options];
//        representation = [rep TIFFRepresentation];
		ok = (representation != nil);
	}
	if ([fileType isEqualToString: @"gif"])    // GNUstep support is missing
	{
        [view lockFocus];
        NSBitmapImageRep * rep =
            [[NSBitmapImageRep alloc] initWithFocusedViewRect: [view bounds]];
        [view unlockFocus];
        [rep autorelease];
        representation = [rep representationUsingType: NSGIFFileType properties: options];
		ok = (representation != nil);
	}
	if ([fileType isEqualToString: @"jpg"])    // GNUstep support is missing
	{
		options = [NSDictionary dictionaryWithObjectsAndKeys:
			[NSNumber numberWithFloat: 25.0], NSImageCompressionFactor, nil];
        [view lockFocus];
        NSBitmapImageRep * rep =
            [[NSBitmapImageRep alloc] initWithFocusedViewRect: [view bounds]];
        [view unlockFocus];
        [rep autorelease];
        representation = [rep representationUsingType: NSJPEGFileType properties: options];
		ok = (representation != nil);
	}
	if ([fileType isEqualToString: @"png"])    // GNUstep support is missing
	{
		options = [NSDictionary dictionaryWithObjectsAndKeys:
			NO, NSImageInterlaced, nil];
        [view lockFocus];
        NSBitmapImageRep * rep =
            [[NSBitmapImageRep alloc] initWithFocusedViewRect: [view bounds]];
        [view unlockFocus];
        [rep autorelease];
        representation = [rep representationUsingType: NSPNGFileType properties: options];
		ok = (representation != nil);
	}
	if ( !ok )
	{
		NSLog (@"Graphics format \"%@\" not supported", fileType);
		return;
	}
	
	[representation writeToFile: [sheet filename] atomically: NO];
}

- (IBAction) saveImage: (id) sender
{
    if (exportAs == nil) [NSBundle loadNibNamed: @"exportAs" owner: self];
    if (exportAs == nil) return;
    if (exportSelector == nil) return;

	savePanel = [NSSavePanel savePanel];
	[savePanel setAccessoryView: exportAs];
	[self changeExportFormat: exportSelector];
	[savePanel beginSheetForDirectory: nil
								 file: nil
					   modalForWindow: [self window]
						modalDelegate: self
					   didEndSelector: @selector(exportPanelDidEnd:returnCode:contextInfo:)
						  contextInfo: imageView];
}

- (IBAction) changeExportFormat: (id) sender
{
    int tag = [[sender selectedCell] tag];
    switch (tag)
    {
        case 0:    // eps
        [savePanel setRequiredFileType: @"eps"];
        break;
        case 1:    // tiff
        [savePanel setRequiredFileType: @"tif"];
        break;
        case 2:
        [savePanel setRequiredFileType: @"gif"];
        break;
        case 3:
        [savePanel setRequiredFileType: @"jpg"];
        break;
        case 4:
        [savePanel setRequiredFileType: @"png"];
        break;
        case 5:
        [savePanel setRequiredFileType: @"pdf"];
        break;
    };
    [savePanel validateVisibleColumns];
}

- (float) alpha { return alpha; }
- (NSCompositingOperation) op { return op; }
- (NSString *) opName { return [opSelect titleOfSelectedItem]; }

- (IBAction) loadImage: (id) sender
{
	NSUserDefaults * defaults = [NSUserDefaults standardUserDefaults];
	NSString * initialFolder = nil;
	if ([[defaults objectForKey: @"xhrSettingsFolderOption"] intValue] == 1)
	{
		initialFolder = [[defaults objectForKey: @"xhrSettingsFolder"] stringByStandardizingPath];
	};
	
	NSOpenPanel * openPanel = [NSOpenPanel openPanel];
    // Nuts! GNUstep has not yet implemented EPS and PDF import
	NSArray * fileTypes = [NSArray arrayWithObjects: /* @"EPS", @"eps", */ @"TIF", @"tif", @"tiff", @"TIFF",
        @"png", @"PNG", @"gif", @"GIF", @"jpg", @"jpeg", @"JPG", @"JPEG", nil];
	[openPanel beginSheetForDirectory: nil
								 file: nil
								types: fileTypes
					   modalForWindow: [self window]
						modalDelegate: self 
					   didEndSelector: @selector(openPanelDidEnd:returnCode:contextInfo:)
						  contextInfo: nil ];
}

- (void)openPanelDidEnd:(NSOpenPanel *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo
{	
	if (returnCode == NSCancelButton) return;
	NSString * filename = [[sheet filenames] objectAtIndex: 0];
    NSImage * anImage = [[[NSImage alloc] initWithContentsOfFile: filename] autorelease];
    if ( anImage == nil ) NSLog(@"Unable to load image file \"%@\"", filename);
    [imageView setImage: anImage];
}

@end
