/* All Rights reserved */

#include <AppKit/AppKit.h>
#include "MyView.h"
#include "AppController.h"

@implementation MyView

- (void) drawRect: (NSRect) aRect;
{
    float alpha = [appController alpha];
    NSCompositingOperation op = [appController op];
    NSColor * gray = [NSColor lightGrayColor];
    NSColor * red = [[NSColor redColor] colorWithAlphaComponent: alpha];
    NSColor * blue = [NSColor blueColor];
    NSColor * black = [NSColor blackColor];
    float w1 = [self bounds].size.width*0.10;
    float w4 = [self bounds].size.width*0.40;
    float h1 = [self bounds].size.height*0.10;
    float h4 = [self bounds].size.height*0.40;
    NSRect blueRect = NSInsetRect( [self bounds], w1, h4 );
    NSRect redRect = NSInsetRect ( [self bounds], w4, h1 );

    [gray set];
    NSRectFill([self bounds]);
    [black set];
    NSFrameRect([self bounds]);
    [blue set];
    NSRectFill(blueRect);
    [red set];
    NSRectFillUsingOperation(redRect, op);    // some printers can't cope with this
//    NSRectFill(redRect);
    NSPoint tp = NSMakePoint(w1, [self bounds].size.height-h1);
    NSString * title = [NSString stringWithFormat: @"%@ \talpha %3.2f", [appController opName], alpha];
    [title drawAtPoint: tp withAttributes: nil];
}

@end
