/*
With LPT_Interface.app one can write & read the parallel port's: 
Data Port (8 bit), Control Port (4 bit) and read Status Port (4 bits).

Author: Csanyi Pal <csanyipal@gmail.com>

Copyright (C) 2010 Csanyi Pal

This file is part of LPT_Interface.app.

LPT_Interface.app is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

LPT_Interface.app is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with LPT_Interface.app.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include <Renaissance/Renaissance.h>

@interface MyDelegate : NSObject
{}
- (void) applicationDidFinishLaunching: (NSNotification *)not;
@end

@implementation MyDelegate : NSObject 


- (void) applicationDidFinishLaunching: (NSNotification *)not;
{
  [NSBundle loadGSMarkupNamed: @"LPT_Interface"  owner: self];
}
@end

int main (int argc, const char **argv)
{ 
  CREATE_AUTORELEASE_POOL (pool);
  MyDelegate *delegate;
  [NSApplication sharedApplication];

  delegate = [MyDelegate new];
  [NSApp setDelegate: delegate];

#ifdef GNUSTEP
  [NSBundle loadGSMarkupNamed: @"Menu-GNUstep"  owner: delegate];
#else
  [NSBundle loadGSMarkupNamed: @"Menu-OSX"  owner: delegate];
#endif

  RELEASE (pool);
  return NSApplicationMain (argc, argv);
}
