#!/bin/bash

set -e

CFLAGS="-fno-builtin -nostdinc -O -I."
LDFLAGS="-nostdlib -Wl,-N -Wl,-Ttext -Wl,100000"
gcc $CFLAGS -c keyboard.c
gcc $CFLAGS -c game.c
gcc $CFLAGS -c kernel.c
gcc $CFLAGS -c video.c
gcc $CFLAGS -c boot.S
gcc $LDFLAGS -o kernel.exec kernel.o keyboard.o video.o game.o boot.o
objcopy -O binary kernel.exec kernel


GRUBDIR=~/testdir/grub-0.5.96
GRUB="$GRUBDIR"/grub/grub
STAGE1="$GRUBDIR"/stage1/stage1
STAGE2="$GRUBDIR"/stage2/stage2
DISKDEV=/dev/fd0
MOUNTPOINT=/mnt/floppy
MPGD="$MOUNTPOINT"/boot/grub

if grep "$DISKDEV" /proc/mounts; then
  echo first unmount floppy
  false
fi

mount "$MOUNTPOINT"
mkdir -p "$MPGD"
cp "$STAGE1" "$STAGE2" kernel "$MPGD"
cat > "$MPGD"/menu.lst <<EOF
timeout 1
title foobar
root (fd0)
kernel /boot/grub/kernel
EOF
sync
sleep 2
umount "$MOUNTPOINT"
printf "root (fd0)\nsetup (fd0)\n" | "$GRUB" --batch
