#include "video.h"
#include "keyboard.h"
#include "sound.h"
#include "delay.h"

struct shot_t {
  int8 x,y; // x==-1 -> inactive shot
};
#define NUMSHOTS 5
struct shot_t shots[NUMSHOTS];
int8 ship;

void display()
{
  // clear screen
  video_usecolor(0,0);
  video_fill(0,0,80,25,0);

  // display shots
  {
    uint8 i;
    video_usecolor(4,0);
    for (i=0;i<NUMSHOTS;++i) {
      if (shots[i].x!=-1) {
	video_putchar(shots[i].x,shots[i].y,'|');
      };
    };
  };

  // display ship
  {
    video_usecolor(5,0);
    video_putchar(ship-1,24,'/');
    video_putchar(ship,23,'_');
    video_putchar(ship+1,24,'\\');
  };

  // show the picture
  video_update();
};

void keywork()
{
  uint8 key;
  for (;;) {
    key=key_decode();
    switch (key) {
    case '<':
      if (ship>1) ship--;
      break;
    case '>':
      if (ship<78) ship++;
      break;
    case ' ':
      {
	uint8 i;
	for (i=0;i<NUMSHOTS;++i) {
	  if (shots[i].x==-1) {
	    shots[i].x=ship;
	    shots[i].y=24;
	    break;
	  };
	};
      };
      break;
    case 'x':
      return;
    };
  };
};

void calculate()
{
  {
    uint8 i;
    for (i=0;i<NUMSHOTS;++i) {
      if (shots[i].x!=-1) {
	shots[i].y--;
	if (shots[i].y==-1) {
	  shots[i].x=-1;
	};
      };
    };
  };
};

void sounder()
{
  {
    uint8 i;
    for (i=0;i<NUMSHOTS;++i) {
      if (shots[i].x!=-1) {
	sound_freq(shots[i].y*100+100);
      }else{
	sound_nosound();
      };
      delay_wait(1193180/50);
    };
  };
  sound_nosound();
};

void game()
{
  /*  {
    uint8 *v = (uint8*)0xb8000;
    uint32 i=100;
    for (;;) {
      v[i++]='Q';
      v[i++]=7;
      delay_wait(1193180/100);
    };
  };
  */
  video_blinkchars(false);
  video_hidecursor();
  {
    uint8 i;
    for (i=0;i<NUMSHOTS;++i) shots[i].x=-1;
  };
  ship=40;

  for (;;) {
    display();
    sounder();
    keywork();
    calculate();
  };
};
