#include "keyboard.h"

#include "io.h"

bool key_dataready()
{
  return ( (inb(0x64)&1) == 1 );
};

uint8 key_readdata()
{
  while (!key_dataready());
  return inb(0x60);
};

uint8 key_decode()
{
  uint8 c;

  for (;;) {
    if (!key_dataready()) return 'x';
    c=key_readdata();

    if (c==0xe0) {
      c=key_readdata();
      if ((c&0x80)==0) {
	if (c==0x4d) return '>';
	if (c==0x4b) return '<';
	if (c==0x48) return '^';
	if (c==0x50) return 'v';
      };
    }else if ((c&0x80)==0) {
      if ((c>=0x3b) && (c<=0x44)) return c-0x3b+'0';
      if (c==0x2a) return 'l';
      if (c==0x36) return 'r';
      if (c==1) return '@';
      if (c==0x1c) return 'e';
      if (c==0x39) return ' ';
    };
  };
};
