(define-module (fixed-packages)
  #:use-module (gnu packages)
  #:use-module (gnu packages games)
  #:use-module (gnu packages gl)
  #:use-module (guix download)
  #:use-module (guix packages)
  #:use-module (guix profiles)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages sdl)
  #:export (guile-sdl2-fixed
	    teeworlds-fixed
	    teeworlds-fixed-with-pkg-config))

(define libepoxy-legacy
  (package
    (inherit libepoxy)
    (version "1.5.0")
    (source (origin
      (method url-fetch)
      (uri (string-append
            "https://github.com/anholt/libepoxy/releases/download/"
            version "/libepoxy-" version ".tar.xz"))
      (sha256
       (base32
        "1md58amxyp34yjnw4xa185hw5jm0hnb2xnhdc28zdsx6k19rk52c"))))))

(define with-libepoxy-legacy
  (package-input-rewriting (list (cons libepoxy libepoxy-legacy))))

(define guile-sdl2-fixed
  (with-libepoxy-legacy guile-sdl2))

(define teeworlds-fixed
  (with-libepoxy-legacy teeworlds))

(define (with-pkg-config pkg)
  (package
    (inherit pkg)
    (native-inputs (cons `("pkg-config" ,pkg-config)
                         (package-native-inputs pkg)))))

(define teeworlds-fixed-with-pkg-config
  (with-pkg-config teeworlds-fixed))
