(define-module (emacs-pkgex)
  #:use-module ((gnu packages rust-apps)  #:select (fd ripgrep))
  #:use-module ((guix build-system emacs) #:select (emacs-build-system))
  #:use-module ((guix gexp)               #:select (local-file))
  #:use-module ((guix git-download)       #:select (git-predicate))
  #:use-module ((guix packages)           #:select (package))
  #:use-module ((guix utils)              #:select (current-source-directory)))

(define file-tracked? (git-predicate (current-source-directory)))

(define-public emacs-pkgex
  (package
   (name "pkgex")
   (version "1")
   (synopsis "Example of an Emacs package with literate programming.")
   (description "")
   (home-page "")
   (license #f)
   (source (local-file "." "ig-ihm-checkout" #:recursive? #t #:select? file-tracked?))
   (build-system emacs-build-system)
   (native-inputs (list fd ripgrep))
   (arguments
    `(#:tests? #t
      #:phases
      (modify-phases
          %standard-phases
        (add-after 'unpack 'tangle (lambda _ (invoke "make" "tangle" "-j"))))))))

emacs-pkgex
