#!/bin/sh

export TEXMFVAR="${XDG_CACHE_HOME:-$HOME/.cache}/texmf-var"

texmf_override='TEXMF = {$TEXMFCONFIG,$TEXMFVAR,$TEXMFHOME,!!$TEXMFSYSCONFIG,!!$TEXMFSYSVAR,!!$TEXMFDIST}'

cd "$1" || exit 1

case $2 in
    -i)
	guix time-machine -C ../channels.scm -- \
	     shell -C --share=$TEXMFVAR --preserve=TEXMFVAR -m manifest.scm
	    ;;
    *)
	guix time-machine -C ../channels.scm -- \
		shell -C --share=$TEXMFVAR --preserve=TEXMFVAR -m manifest.scm -- \
			strace -o access.txt -e access -- \
			lualatex test.ltx
	    ;;
esac
