#define _GNU_SOURCE 1

#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <fcntl.h> /* O_READ etc. */

#include <hurd/ports.h>
#include <hurd/hurd_types.h>
#include <hurd/trivfs.h>

#include <syslog.h>
#include "logrelay.h"

#include <sys/stat.h>
#include <getopt.h>

/* Mandatory user defined trivfs functions */

int trivfs_fstype = FSTYPE_MISC; /* Generic trivfs server 
				  * (see <hurd/hurd_types.h>)
				  */
int trivfs_fsid = 0;		 /* Should always be 0 on startup */

int trivfs_allow_open = O_READ;  /* translator initial permissions */

/* what kinds of accesses are actually implemented */
int trivfs_support_read = 0;
int trivfs_support_write = 0;
int trivfs_support_exec = 0;

void 
trivfs_modify_stat (struct trivfs_protid *cred, io_statbuf_t  *st)
{
}

error_t 
trivfs_goaway (struct trivfs_control *fsys, int flags)
{
  exit (EXIT_SUCCESS);
}

/* End of mandatory user-defined trivfs functions */


int 
demuxer (mach_msg_header_t *inp, mach_msg_header_t *outp)
{
  extern boolean_t S_logrelay_server
    (mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP);

  return (S_logrelay_server(inp,outp)||trivfs_demuxer(inp,outp));
}

kern_return_t 
S_send_log (mach_port_t data_port, 
		string_t proc_name,
		string_t msg,
		int pri_value, 
		int fac_value)
{
  openlog("logrelay", LOG_PID, fac_value);
  syslog(pri_value, "%s reports %s", proc_name, msg);
  closelog();

  return 0;
}

int
main(int argc, char **argv)
{
  error_t err;
  mach_port_t bootstrap;
  struct trivfs_control *fsys;

  task_get_bootstrap_port (mach_task_self (), &bootstrap);
  if (bootstrap == MACH_PORT_NULL) {
    fprintf(stderr, "Must be started as a translator!\n\n");
    fprintf(stderr, "Usage: settrans [opts] node %s\n\n", program_invocation_name); 
    exit (1);
  }

  /* Reply to our parent */
  err = trivfs_startup (bootstrap, 0, 0, 0, 0, 0,&fsys);
  if (err) 
    error (1, err, "trivfs_startup failed");

  mach_port_deallocate (mach_task_self (), bootstrap);

  ports_manage_port_operations_multithread (fsys->pi.bucket, demuxer,
						0, 0, NULL);
  return 0;
}

