const fetch = require("node-fetch")
const crypto = require("crypto")
const fs = require("fs")
const obj = {}
const debug = true

function promise_wrapping(promise, ...rest) {
  return new Promise((res, rej) => {
    promise
    .then(x => res([x, ...rest]))
    .catch(x => rej())
  })
}

const debug_arr = (should, amount) => {
  return new Promise((res, rej) => {
    if (!should) {
      res([ { name: "jquery" } ])
    } else {
      fetch("https://api.cdnjs.com/libraries")
      .then(res => res.json())
      .then(response => res(response.results.slice(0, amount)))
    }
  })
}


const sync_promises = (promise, args) => {
  const ret = []
  return new Promise((res, rej) => {
    const recursive_promises = index => {
        if (index === args.length) {
          console.log("what")
          res(ret)
          return
        }
        promise(index, args[index]).then(result => {
          ret.push(result)
          recursive_promises(++index)
        }).catch(e => rej(e))
    }
    recursive_promises(0)
  })
}

const beginning_point = (index, value) => {
  return new Promise((resolve, reject) => {
    fetch(`https://api.cdnjs.com/libraries/${value.name}`)
    .then(res => res.json())
    .then(lib => {
      return Promise.all(lib.assets.map(asset => {
        return new Promise((res, rej) => {

        const filtered = asset.files.filter(file => {
          return file.endsWith(".js")
        })
        if (filtered.length === 0) resolve()
        let x = []
        filtered.map(file => {
          fetch(`https://cdnjs.cloudflare.com/ajax/libs/${value.name}/${asset.version}/${file}`)
          .then(resp => {
            resp.body.pipe(crypto.createHash("sha256").setEncoding("hex")).on("finish", function() {
              x.push({ hash: this.read(), file: file, version: asset.version })
              if (x.length === filtered.length) {
                //console.log(x)
                res(x)
              }
            })
          })
        })
      })
    }))
    .then(x => resolve({hashes: [  ].concat.apply( [  ], x ), title: value.name }))
  })
})}

debug_arr(true, 5)
.then(res => sync_promises(beginning_point, res))
.then(x => console.log(JSON.stringify(x, null, "\t")))

/*
.then(fetch_arr => {
  fetch_arr.map((value, ind) => {
    fetch(`https://api.cdnjs.com/libraries/${value.name}`)
    .then(res => {
      return res.json()
    })
    .then(lib => {
      obj[lib.name] = []
      const next = ind => {
        if (ind === lib.assets.length) {
          console.log("Done")
          return
        }
        console.log("Processing", ind)
        const asset = lib.assets[ind]
        //lib.assets.map(asset => {
          const filtered = asset.files.filter(file => {
            return file.endsWith(".js")
          })
          filtered.map((file, index) => {
            fetch(`https://cdnjs.cloudflare.com/ajax/libs/${lib.name}/${asset.version}/${file}`)
            .then(res => {
              if (debug) console.log("Currently processing", `${lib.name}/${asset.version}/${file}`)
              res.body.pipe(crypto.createHash("sha256").setEncoding("hex")).on("finish", function() {
                obj[lib.name].push({ version: asset.version, hash: this.read(), filename: file })
                if (debug) console.log("Finished processing", `${lib.name}/${asset.version}/${file}`)
                ++index === filtered.length ? next(++ind) : false
              })
            })
          })
        }
      next(0)
    })
  })
})*/
