#include <io.h>
#include <sched.h>
#include <interrupt.h>
#include <round_buffer.h>

int sys_write_console(char *buffer,int size){
	int i;
	for (i = 0; i<size; i++){
		printc(buffer[i]);
	}
	return i;
}

int sys_read_console(char *buffer,int size){
	int i=0;
	struct task_struct* act = current();
	if (hay_blocked() && act->pid==0) return 0;	// EL PROCESO INICIAL NO SE PUEDE BLOQUEAR
	if (hay_blocked()){
		act->read_left = size;		// ACTUALIZAMOS LOS CAMPOS @ DEL BUFFER DE LECTURA Y NÚMERO DE CHAR A LEER DEL TASK_STRUCT
		act->read_buff = buffer;
		act->read_done = 0;
		bloquear (act);
	}
	else{
		while ((keyboard_buff.n > 0) && (size > 0)){
			buffer[i] = leer(&keyboard_buff);
			i++;
			size--;
			act->read_done = i;
		}
		if ( size > 0 ){
			act->read_left = size;		
			act->read_buff = buffer;
			bloquear (act);
		}
	}
	return act->read_done;
}
