/*
 * entry.S - Entry point to system mode from user mode
 */

#include <asm.h>
#include <segment.h>

/* ***************************************** */
/*           TAULA DE RUTINES DE SYS_CALLS   */
/* ***************************************** */	

ENTRY (sys_call_table)
   .long sys_ni_call /*  0 */
   .long sys_exit    /*  1 */
   .long sys_fork    /*  2 */
   .long sys_read    /*  3 */
   .long sys_write   /*  4 */
   .long sys_ni_call /*  5 */
   .long sys_close   /*  6 */
   .long sys_ni_call /*  7 */
   .long sys_ni_call /*  8 */
   .long sys_ni_call /*  9 */
   .long sys_ni_call /* 10 */
   .long sys_ni_call /* 11 */
   .long sys_ni_call /* 12 */
   .long sys_ni_call /* 13 */
   .long sys_ni_call /* 14 */
   .long sys_ni_call /* 15 */
   .long sys_ni_call /* 16 */
   .long sys_ni_call /* 17 */
   .long sys_ni_call /* 18 */
   .long sys_ni_call /* 19 */
   .long sys_getpid  /* 20 */
   .long sys_sem_init /* 21 */
   .long sys_sem_wait /* 22 */
   .long sys_sem_signal /* 23 */
   .long sys_ni_call /* 24 */
   .long sys_ni_call /* 25 */
   .long sys_ni_call /* 26 */
   .long sys_ni_call /* 27 */
   .long sys_ni_call /* 28 */
   .long sys_ni_call /* 29 */
   .long sys_ni_call /* 30 */
   .long sys_ni_call /* 31 */
   .long sys_ni_call /* 32 */
   .long sys_ni_call /* 33 */
   .long sys_nice    /* 34 */
   .long sys_get_stats /* 35 */
   .long sys_ni_call /* 36 */
   .long sys_ni_call /* 37 */
   .long sys_ni_call /* 38 */
   .long sys_ni_call /* 39 */
   .long sys_ni_call /* 40 */
   .long sys_dup /* 41 */
sys_call_table_size = (.-sys_call_table)

#define SYS_CALL_NUMBER	(sys_call_table_size / 4)

/**************************************************/
/**** Save & Restore ******************************/
/**                                              **/
/** When we change to privilege level 0 (kernel) **/
/** (through an interrupt, a system call, an     **/
/** exception ...) we must save the state of the **/
/** currently running task (save).               **/
/**                                              **/
/** Stack layout in 'systemCall':                **/
/**                                              **/
/**   0(%esp) - %ebx    \                        **/
/**   4(%esp) - %ecx     |                       **/
/**   8(%esp) - %edx     |                       **/
/**   C(%esp) - %esi     | Register saved        **/
/**  10(%esp) - %edi     |  by 'save'            **/
/**  14(%esp) - %ebp     |                       **/
/**  18(%esp) - %eax     |                       **/
/**  1C(%esp) - %ds      |                       **/
/**  20(%esp) - %es      |                       **/
/**  24(%esp) - %fs      |                       **/
/**  28(%esp) - %gs     /                        **/
/**  2C(%esp) - %eip    \                        **/
/**  30(%esp) - %cs      |                       **/
/**  34(%esp) - %eflags  |  Return context saved **/
/**  38(%esp) - %oldesp  |   by the processor.   **/
/**  3C(%esp) - %oldss  /                        **/
/**                                              **/
/**************************************************/

#define EOI ;  \
      movb $0x20, %al; \
      outb %al, $0x20;

#define SAVE_ALL ;  \
      pushl %gs; \
      pushl %fs; \
      pushl %es; \
      pushl %ds; \
      pushl %eax; \
      pushl %ebp; \
      pushl %edi; \
      pushl %esi; \
      pushl %edx; \
      pushl %ecx; \
      pushl %ebx; \
      movl $__KERNEL_DS, %edx;    \
      movl %edx, %ds;           \
      movl %edx, %es; \

#define RESTORE_ALL ;  \
      popl %ebx; \
      popl %ecx; \
      popl %edx; \
      popl %esi; \
      popl %edi; \
      popl %ebp; \
      popl %eax; \
      popl %ds; \
      popl %es; \
      popl %fs; \
      popl %gs; \
 
/* ***************************************** */
/*                      HANDLERS RSE         */
/* ***************************************** */

ENTRY (divide_error_handler)
  SAVE_ALL                            
  CALL divide_error_routine    
  RESTORE_ALL                       
  iret                                        
 
ENTRY (debug_handler)
  SAVE_ALL                            
  CALL debug_routine    
  RESTORE_ALL                       
  iret              

ENTRY (NM1_handler)
  SAVE_ALL                            
  CALL NM1_routine    
  RESTORE_ALL                       
  iret              
      
ENTRY (breakpoint_handler)
  SAVE_ALL                            
  CALL breakpoint_routine    
  RESTORE_ALL                       
  iret              

ENTRY (overflow_handler)
  SAVE_ALL                            
  CALL overflow_routine    
  RESTORE_ALL                       
  iret              

ENTRY (bounds_check_handler)
  SAVE_ALL                            
  CALL bounds_check_routine    
  RESTORE_ALL                       
  iret              

ENTRY (invalid_opcode_handler)
  SAVE_ALL                            
  CALL invalid_opcode_routine    
  RESTORE_ALL                       
  iret              

ENTRY (device_not_avaiable_handler)
  SAVE_ALL                            
  CALL device_not_avaiable_routine    
  RESTORE_ALL                       
  iret              

ENTRY (double_fault_handler)
  SAVE_ALL                            
  pushl (%esp)
  CALL double_fault_routine    
  RESTORE_ALL                       
  addl $8, %esp
  iret              

ENTRY (coprocessor_segment_overrun_handler)
  SAVE_ALL                            
  CALL coprocessor_segment_overrun_routine    
  RESTORE_ALL   
  iret
     
ENTRY (invalid_TSS_handler)    
  SAVE_ALL    
  pushl (%esp)                        
  CALL invalid_TSS_routine
  addl $8, %esp
  RESTORE_ALL                       
  iret              

ENTRY (segment_not_present_handler)
  SAVE_ALL                            
  pushl (%esp)
  CALL segment_not_present_routine    
  addl $8, %esp
  RESTORE_ALL                       
  iret              

ENTRY (stack_exception_handler)
  SAVE_ALL      
  pushl (%esp)                        
  CALL stack_exception_routine    
  addl $8, %esp
  RESTORE_ALL                       
  iret              

ENTRY (general_protection_handler)
  SAVE_ALL
  pushl (%esp)                       
  CALL general_protection_routine    
  addl $8, %esp
  RESTORE_ALL                       
  iret              

ENTRY (page_fault_handler)
  SAVE_ALL                            
  pushl (%esp)
  CALL page_fault_routine    
  addl $8, %esp
  RESTORE_ALL                       
  iret              

ENTRY (floating_point_error_handler)
  SAVE_ALL                            
  CALL floating_point_error_routine    
  RESTORE_ALL                       
  iret              

ENTRY (alignment_check_handler)
  SAVE_ALL                            
  pushl (%esp)
  CALL alignment_check_routine    
  addl $8, %esp
  RESTORE_ALL                       
  iret             

/* ***************************************** */
/*                      HANDLERS RSI         */
/* ***************************************** */

ENTRY (Clock_handler)
  SAVE_ALL
  CALL Clock_routine   
  EOI
  RESTORE_ALL
  iret

ENTRY (KeyBoard_handler)
  SAVE_ALL
  CALL KeyBoard_routine
  EOI
  RESTORE_ALL               
  iret

/* ***************************************** */
/*           HANDLERS CRIDES A SISTEMA       */
/* ***************************************** */

ENTRY (system_call_handler)
  SAVE_ALL
  cmpl $0,%eax
  jl else
  cmpl $SYS_CALL_NUMBER, %eax
  jg else
       /* invocar crida al sistema */
       call *sys_call_table(, %eax, 0x04)
       movl %eax, 0x18(%esp)
       jmp endif
else:
       /* return ENOSYS */
       movl $-38, 0x18(%esp)
endif:
   RESTORE_ALL
   iret


	
  
