/*
 * fd.h - Estructures i macros per les taules de canals
 */

#ifndef __FD_H__
#define __FD_H__

#define NR_DEVICES 4

#define STD_OUTPUT 1
#define STD_INPUT 0
#define STD_ERROR 2

struct channel {
  char status;	
  char mode;
  struct device_descriptor* dd;	
};

struct device_descriptor {
	int (*read)();
	int (*write)(char *pbuff, int psize);
	void (*close)();
	void (*duplicate)();
};

extern struct device_descriptor t_devices[NR_DEVICES];

void init_devices_descriptors();

#endif 
