/*
 * interrupt.h - Definició de les diferents rutines de tractament d'exepcions
 */

#ifndef __INTERRUPT_H__
#define __INTERRUPT_H__

#define IDT_ENTRIES 256
#define TICS_PER_SECOND 18

extern Gate idt[IDT_ENTRIES];
extern Register idtR;
extern struct round_buffer keyboard_buff;

void setInterruptHandler(int vector, void (*handler)(), int maxAccessibleFromPL);
void setTrapHandler(int vector, void (*handler)(), int maxAccessibleFromPL);

void setIdt();

// RSE
void divide_error_handler();
void debug_handler();
void NM1_handler();
void breakpoint_handler();
void overflow_handler();  
void bounds_check_handler();
void invalid_opcode_handler();
void device_not_avaiable_handler();       
void double_fault_handler();    
void coprocessor_segment_overrun_handler();
void invalid_TSS_handler();                     
void segment_not_present_handler();
void stack_exception_handler();         
void general_protection_handler();       
void page_fault_handler();
void floating_point_error_handler();       
void alignment_check_handler();
void actualizar_clock();

// RSI
void Clock_handler();
void print_clock();
void KeyBoard_handler();

// Sys_calls
void system_call_handler();

#endif  /* __INTERRUPT_H__ */
