/*
 * sched.h - Estructures i macros pel tractament de processos
 */

#ifndef __SCHED_H__
#define __SCHED_H__

#define DEFAULT_QUANTUM 1

#define STATUS_RUN 0
#define STATUS_READY 1
#define STATUS_BLOCKED 2
#define STATUS_ZOMBIE 3

#define NR_TASKS      10
#define KERNEL_STACK_SIZE	1024
#define NR_CHANELS 10

#include <list.h>
#include <fd.h>
#include <mm_address.h>
#include <types.h>

struct task_struct {
  struct list_head lh;			// +0 -> prev +4 -> next
  int pid;					// +8
  int ppid;				// +c
  int status;				// +10
  int quantum;				// +14
  DWord esp;				// +18
  int cpu_time;				// +24
  char *read_buff;			// +28
  int read_left;			// +2c
  int read_done;			// +30
  struct channel tc[NR_CHANELS];	// +34 -> status, +38 -> mode, +3c -> &t_devices
  int tp[NUM_PAG_DATA];			// Tabla de paginas
};

union task_union {
  struct task_struct task;
  unsigned long stack[KERNEL_STACK_SIZE];    /* pila de sistema, per procés */
};

struct task_struct* current();
extern union task_union task[NR_TASKS];
extern page_table_entry pagusr_table[TOTAL_PAGES];
extern char task_bitmap[NR_TASKS];
extern int total_process;
extern struct list runqueue;

/* Inicialitza les dades del proces inicial */
void init_task0();
void task_schedule();
void task_switch (union task_union *t);
void switch_process(struct task_struct *nuevo, struct task_struct *act);
struct task_struct* list_head_to_task_struct(struct list_head* l);
char hay_blocked ();
void bloquear(struct task_struct *p);
#endif  /* __SCHED_H__ */
