/*
 * interrupt.c -
 */
#include <types.h>
#include <sched.h>
#include <interrupt.h>
#include <segment.h>
#include <hardware.h>
#include <io.h>
#include <utils.h>
#include <round_buffer.h>

Gate idt[IDT_ENTRIES];
Register    idtR;
int tics = 0;
struct round_buffer keyboard_buff;

char char_map[] =
{
  '\0','\0','1','2','3','4','5','6',
  '7','8','9','0','\'','','\0','\0',
  'q','w','e','r','t','y','u','i',
  'o','p','`','+','\n','\0','a','s',
  'd','f','g','h','j','k','l','',
  '\0','','\0','','z','x','c','v',
  'b','n','m',',','.','-','\0','*',
  '\0',' ','\0','\0','\0','\0','\0','\0',
  '\0','\0','\0','\0','\0','\0','\0','7',
  '8','9','-','4','5','6','+','1',
  '2','3','0','\0','\0','\0','<','\0',
  '\0','\0','\0','\0','\0','\0','\0','\0',
  '\0','\0'
};

void setInterruptHandler(int vector, void (*handler)(), int maxAccessibleFromPL)
{
  /***********************************************************************/
  /* THE INTERRUPTION GATE FLAGS:                          R1: pg. 5-11  */
  /* ***************************                                         */
  /* flags = x xx 0x110 000 ?????                                        */
  /*         |  |  |                                                     */
  /*         |  |   \ D = Size of gate: 1 = 32 bits; 0 = 16 bits         */
  /*         |   \ DPL = Num. higher PL from which it is accessible      */
  /*          \ P = Segment Present bit                                  */
  /***********************************************************************/
  Word flags = (Word)(maxAccessibleFromPL << 13);
  flags |= 0x8E00;    /* P = 1, D = 1, Type = 1110 (Interrupt Gate) */

  idt[vector].lowOffset       = lowWord((DWord)handler);
  idt[vector].segmentSelector = __KERNEL_CS;
  idt[vector].flags           = flags;
  idt[vector].highOffset      = highWord((DWord)handler);
}

void setTrapHandler(int vector, void (*handler)(), int maxAccessibleFromPL)
{
  /***********************************************************************/
  /* THE TRAP GATE FLAGS:                                  R1: pg. 5-11  */
  /* ********************                                                */
  /* flags = x xx 0x111 000 ?????                                        */
  /*         |  |  |                                                     */
  /*         |  |   \ D = Size of gate: 1 = 32 bits; 0 = 16 bits         */
  /*         |   \ DPL = Num. higher PL from which it is accessible      */
  /*          \ P = Segment Present bit                                  */
  /***********************************************************************/
  Word flags = (Word)(maxAccessibleFromPL << 13);

  //flags |= 0x8F00;    /* P = 1, D = 1, Type = 1111 (Trap Gate) */
  /* Changed to 0x8e00 to convert it to an 'interrupt gate' and so
     the system calls will be thread-safe. */
  flags |= 0x8E00;    /* P = 1, D = 1, Type = 1110 (Interrupt Gate) */

  idt[vector].lowOffset       = lowWord((DWord)handler);
  idt[vector].segmentSelector = __KERNEL_CS;
  idt[vector].flags           = flags;
  idt[vector].highOffset      = highWord((DWord)handler);
}
void setIdt()
{
  /* Program interrups/exception service routines */
  idtR.base  = (DWord)idt;
  idtR.limit = IDT_ENTRIES * sizeof(Gate) - 1;
  /* ADD INITIALIZATION CODE FOR INTERRUPT VECTOR */
  set_idt_reg(&idtR);

  /* *************************************************
                     EXCEPCIONES
  ***************************************************/
  setInterruptHandler(0, divide_error_handler, 0);
  setInterruptHandler(1, debug_handler, 0);
  setInterruptHandler(2, NM1_handler, 0);
  setInterruptHandler(3, breakpoint_handler, 0);
  setInterruptHandler(4, overflow_handler, 0);
  setInterruptHandler(5, bounds_check_handler, 0);
  setInterruptHandler(6, invalid_opcode_handler, 0);
  setInterruptHandler(7, device_not_avaiable_handler, 0);
  setInterruptHandler(8, double_fault_handler, 0);
  setInterruptHandler(9, coprocessor_segment_overrun_handler , 0);
  setInterruptHandler(10, invalid_TSS_handler, 0);
  setInterruptHandler(11, segment_not_present_handler, 0);
  setInterruptHandler(12, stack_exception_handler, 0);
  setInterruptHandler(13, general_protection_handler, 0);
  setInterruptHandler(14, page_fault_handler, 0);
  setInterruptHandler(16, floating_point_error_handler, 0);
  setInterruptHandler(17, alignment_check_handler, 0);

  /* *******************************************************
                       INTERRUPCIONES
  **********************************************************/
  setInterruptHandler(32, Clock_handler, 0);		  // RELOJ
  setInterruptHandler(33, KeyBoard_handler, 0);		  // TECLADO

 /* *******************************************************
                       TRAP
  **********************************************************/
  setTrapHandler(0x80,system_call_handler,3);
  inicializar(&keyboard_buff);
}

/* ******************************************
                                     RSE
 ********************************************/
void divide_error_routine(){
	printk("Exception: Division by 0\n");
	while(1);
}

void debug_routine(){
	printk("Exception: Debug\n");
	while(1);
}

void NM1_routine(){
	printk("Exception: NM1\n");
	while(1);
}

void breakpoint_routine(){
	printk("Exception: Breakpoint\n");
	while(1);
}

void overflow_routine(){
	printk("Exception: Overflow\n");
	while(1);
}

void bounds_check_routine(){
	printk("Exception: bounds check\n");
	while(1);
}

void invalid_opcode_routine(){
	printk("Exception: invalid opcode\n");
	while(1);
}

void device_not_avaiable_routine(){
	printk("Exception: device not avaiable\n");
	while(1);
}

void double_fault_routine(int x){
	printk("Exception: Double fault\n");
	while(1);
}

void coprocessor_segment_overrun_routine(){
	printk("Exception: Coprocessor segment overrun\n");
	while(1);
}

void invalid_TSS_routine(int x){
	printk("Exception: Invalid TSS\n");
	while(1);
}

void segment_not_present_routine(int x){
	printk("Exception: segment not present\n");
	while(1);
}

void stack_exception_routine(int x){
	printk("Exception: Stack exception\n");
	while(1);
}

void general_protection_routine(int x){
	printk("Exception: general protection\n");
	while(1);
}

void page_fault_routine(int x){
	printk("Exception: Page fault\n");
	while(1);
}

void floating_point_error_routine(){
	printk("Exception: Floating point error\n");
	while(1);
}

void alignment_check_routine(int x){
	printk("Exception: Alignment check\n");
	while(1);
}

/* **************************************************
                                     RSI
 ****************************************************/

void Clock_routine(){
	tics ++;
	actualizar_clock();
	task_schedule();
}

void actualizar_clock() {
	if (tics % TICS_PER_SECOND == 0){
		print_clock();
	}
}

void print_clock(){
	char buff[16];
	int s = (tics / TICS_PER_SECOND) % 60;
	int m = tics / (TICS_PER_SECOND * 60);
	itoa (s, buff);
	if (s<10) {
		printc_xy(78, 0, '0');
		printk_xy(79, 0, buff);
	}
	else{
		printk_xy(78, 0, buff);
	}
	itoa (m, buff);
	if (m<10) {
		printc_xy(75, 0, '0');
		printk_xy(76, 0, buff);
	}
	else{
		printk_xy(77-strlen(buff), 0, buff);
	}
	printc_xy(77, 0, ':');
}

void KeyBoard_routine(){
	unsigned char tecla = inb(0x60); // tecla CONTIENE EL CODIGO DE RASTREO
	char valor;
	char aux=tecla & 0x80; // AUX INDICA SI ES MAKE O BREAK
	if (!aux) { // SI ES UN MAKE 
		valor = char_map[tecla];	// valor CONTIENE EL CODIGO ASCII PULSADO
		if (valor!='\0'){ // SI ES IMPRIMIBLE
			printc(valor); // IMPRIMIMOS valor
			print_clock(); // Actualizamos el reloj para que no se pierda
		}
		//else
			//printk_xy("Control"); //NO ES IMPRIMIBLE -> Control
	}
	//else BREAK
}
